/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

import hudson.Launcher;
import hudson.Proc;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class CustomDecoratedLauncher
extends Launcher.DecoratedLauncher {
    private static final String MASKED_PASSWORD = "********";
    private Pattern passwordsAsPattern = null;

    public CustomDecoratedLauncher(@Nonnull Launcher inner, Collection<String> passwords) {
        super(inner);
        if (passwords != null && passwords.size() > 0) {
            StringBuilder regex = new StringBuilder().append('(');
            int nbMaskedPasswords = 0;
            if (passwords != null && passwords.size() > 0) {
                for (String password : passwords) {
                    if (!StringUtils.isNotEmpty((String)password)) continue;
                    regex.append(Pattern.quote(password));
                    regex.append('|');
                    try {
                        String encodedPassword = URLEncoder.encode(password, "UTF-8");
                        if (!encodedPassword.equals(password)) {
                            regex.append(Pattern.quote(encodedPassword));
                            regex.append('|');
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    ++nbMaskedPasswords;
                }
            }
            if (nbMaskedPasswords++ > 0) {
                regex.deleteCharAt(regex.length() - 1);
                regex.append(')');
                this.passwordsAsPattern = Pattern.compile(regex.toString());
            }
        }
    }

    public Proc launch(Launcher.ProcStarter ps) throws IOException {
        String[] cmdCopy = ps.cmds().toArray(new String[ps.cmds().size()]);
        if (this.passwordsAsPattern != null) {
            for (int i = 0; i < cmdCopy.length; ++i) {
                cmdCopy[i] = this.passwordsAsPattern.matcher(cmdCopy[i]).replaceAll(MASKED_PASSWORD);
            }
        }
        this.printCommandLine(cmdCopy, ps.pwd());
        return this.getInner().launch(ps);
    }
}

