/*
 * Decompiled with CFR 0.152.
 */
package com.smartbear.jenkins.plugins.testcomplete;

public class Base64 {
    private static int[] integers = new int[128];
    private static final char[] symbols = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public String encode(byte[] buffer) {
        int totalSize = buffer.length;
        char[] ar = new char[(totalSize + 2) / 3 * 4];
        int a = 0;
        int i = 0;
        while (i < totalSize) {
            byte b0 = buffer[i++];
            byte b1 = i < totalSize ? buffer[i++] : (byte)0;
            byte b2 = i < totalSize ? buffer[i++] : (byte)0;
            int mask = 63;
            ar[a++] = symbols[b0 >> 2 & mask];
            ar[a++] = symbols[(b0 << 4 | (b1 & 0xFF) >> 4) & mask];
            ar[a++] = symbols[(b1 << 2 | (b2 & 0xFF) >> 6) & mask];
            ar[a++] = symbols[b2 & mask];
        }
        switch (totalSize % 3) {
            case 1: {
                ar[--a] = 61;
            }
            case 2: {
                ar[--a] = 61;
            }
        }
        return new String(ar);
    }

    public byte[] decode(String s) {
        int delta = s.endsWith("==") ? 2 : (s.endsWith("=") ? 1 : 0);
        byte[] buffer = new byte[s.length() * 3 / 4 - delta];
        int mask = 255;
        int index = 0;
        for (int i = 0; i < s.length(); i += 4) {
            int c0 = integers[s.charAt(i)];
            int c1 = integers[s.charAt(i + 1)];
            buffer[index++] = (byte)((c0 << 2 | c1 >> 4) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c2 = integers[s.charAt(i + 2)];
            buffer[index++] = (byte)((c1 << 4 | c2 >> 2) & mask);
            if (index >= buffer.length) {
                return buffer;
            }
            int c3 = integers[s.charAt(i + 3)];
            buffer[index++] = (byte)((c2 << 6 | c3) & mask);
        }
        return buffer;
    }

    static {
        for (int i = 0; i < symbols.length; ++i) {
            Base64.integers[Base64.symbols[i]] = i;
        }
    }
}

