/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.modules.windows_slave_installer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import hudson.util.jna.DotNet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.modules.slave_installer.InstallationException;
import org.jenkinsci.modules.slave_installer.LaunchConfiguration;
import org.jenkinsci.modules.slave_installer.Prompter;
import org.jenkinsci.modules.slave_installer.SlaveInstaller;
import org.jenkinsci.modules.windows_slave_installer.Messages;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class WindowsSlaveInstaller
extends SlaveInstaller {
    private static final Logger LOGGER = Logger.getLogger(WindowsSlaveInstaller.class.getName());
    private static final Set<String> ADDITIONAL_REQUIRED_MACROS = new TreeSet<String>(Arrays.asList("AGENT_DOWNLOAD_URL"));
    private static final long serialVersionUID = 1L;

    public Localizable getConfirmationText() {
        return Messages._WindowsSlaveInstaller_ConfirmInstallation();
    }

    static int runElevated(File agentExe, String command, TaskListener out, File pwd) throws IOException, InterruptedException {
        return new Launcher.LocalLauncher(out).launch().cmds(agentExe, new String[]{command}).stdout(out).pwd(pwd).join();
    }

    public void install(LaunchConfiguration params, Prompter prompter) throws InstallationException, IOException, InterruptedException {
        this.install(params, prompter, false);
    }

    @SuppressFBWarnings(value={"DM_EXIT", "RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Legacy design, but as designed")
    void install(LaunchConfiguration params, Prompter prompter, boolean mock) throws InstallationException, IOException, InterruptedException {
        if (!mock && !DotNet.isInstalled((int)4, (int)0)) {
            throw new InstallationException(Messages.WindowsSlaveInstaller_DotNetRequired());
        }
        File dir = params.getStorage().getAbsoluteFile();
        if (!dir.exists() && !dir.mkdirs()) {
            throw new InstallationException(Messages.WindowsSlaveInstaller_RootFsCreationFailed(dir));
        }
        params.getLatestJarURL();
        File agentExe = new File(dir, "jenkins-slave.exe");
        FileUtils.copyURLToFile((URL)WindowsSlaveInstaller.class.getResource("jenkins-slave.exe"), (File)agentExe);
        new File(dir, "jenkins-slave.exe.config").delete();
        String serviceId = WindowsSlaveInstaller.generateServiceId(dir.getPath());
        String xml = WindowsSlaveInstaller.generateSlaveXml(serviceId, System.getProperty("java.home") + "\\bin\\java.exe", null, params.buildRunnerArguments().toStringWithQuote(), Arrays.asList(new AgentURLMacroProvider(params)));
        FileUtils.writeStringToFile((File)new File(dir, "jenkins-slave.xml"), (String)xml, (String)"UTF-8");
        File dstAgentJar = new File(dir, "slave.jar").getCanonicalFile();
        if (!dstAgentJar.exists()) {
            FileUtils.copyFile((File)params.getJarFile(), (File)dstAgentJar);
        }
        if (mock) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamTaskListener task = new StreamTaskListener((OutputStream)baos);
        int r = WindowsSlaveInstaller.runElevated(agentExe, "install", (TaskListener)task, dir);
        if (r != 0) {
            throw new InstallationException(baos.toString());
        }
        Runtime.getRuntime().addShutdownHook(new ServiceStarterThread(agentExe, dir, serviceId));
        System.exit(0);
    }

    public static String generateServiceId(String slaveRoot) throws IOException {
        return "jenkinsslave-" + slaveRoot.replace(':', '_').replace('\\', '_').replace('/', '_');
    }

    @Deprecated
    public static String generateSlaveXml(String id, String java, String vmargs, String args) throws IOException {
        return WindowsSlaveInstaller.generateSlaveXml(id, java, vmargs, args, Collections.emptyMap());
    }

    public static String generateSlaveXml(String id, String java, String vmargs, String args, @Nonnull Map<String, String> extraMacroValues) throws IOException {
        String xml = IOUtils.toString((InputStream)WindowsSlaveInstaller.class.getResourceAsStream("jenkins-slave.xml"), (String)"UTF-8");
        xml = xml.replace("@ID@", id);
        xml = xml.replace("@JAVA@", java);
        xml = xml.replace("@VMARGS@", StringUtils.defaultString((String)vmargs));
        xml = xml.replace("@ARGS@", args);
        xml = xml.replace("\n", "\r\n");
        HashMap<String, String> toResolve = new HashMap<String, String>(extraMacroValues);
        Collection<MacroValueProvider> defaultProviders = MacroValueProvider.allDefaultProviders();
        block0: for (String string : ADDITIONAL_REQUIRED_MACROS) {
            if (extraMacroValues.containsKey(string)) continue;
            for (MacroValueProvider provider : defaultProviders) {
                String defaultValue = provider.getDefaulValue(string);
                if (defaultValue == null) continue;
                toResolve.put(string, defaultValue);
                continue block0;
            }
        }
        for (Map.Entry entry : toResolve.entrySet()) {
            xml = xml.replace("@" + (String)entry.getKey() + "@", (CharSequence)entry.getValue());
        }
        if (xml.contains("@")) {
            HashSet<String> unresolvedMacros = new HashSet<String>();
            for (String macroName : ADDITIONAL_REQUIRED_MACROS) {
                if (!xml.contains("@" + macroName + "@")) continue;
                unresolvedMacros.add(macroName);
            }
            throw new IOException("Unresolved macros in the XML file: " + StringUtils.join(unresolvedMacros, (String)","));
        }
        return xml;
    }

    static String generateSlaveXml(String id, String java, @CheckForNull String vmargs, @Nonnull String args, @Nonnull Iterable<MacroValueProvider> providers) throws IOException {
        TreeMap<String, String> macroValues = new TreeMap<String, String>();
        for (MacroValueProvider provider : providers) {
            macroValues.putAll(provider.getMacroValues());
        }
        return WindowsSlaveInstaller.generateSlaveXml(id, java, vmargs, args, macroValues);
    }

    static class AgentURLMacroProvider
    extends MacroValueProvider {
        static final String MACRO_NAME = "AGENT_DOWNLOAD_URL";
        static final String DEFAULT_DISABLED_VALUE = "<!-- <download from=\"TODO:jarFile\" to=\"%BASE%\\slave.jar\"/> -->";
        private static final Set<String> MACRO_NAMES = new TreeSet<String>(Arrays.asList("AGENT_DOWNLOAD_URL"));
        @CheckForNull
        private final LaunchConfiguration launchConfiguration;

        public AgentURLMacroProvider(@CheckForNull LaunchConfiguration launchConfig) {
            this.launchConfiguration = launchConfig;
        }

        @Override
        public Map<String, String> getMacroValues() {
            TreeMap<String, String> res = new TreeMap<String, String>();
            URL remotingURL = null;
            if (this.launchConfiguration != null) {
                try {
                    remotingURL = this.launchConfiguration.getLatestJarURL();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "Failed to retrieve the latest Remoting JAR URL. Auto-download will be disabled", ex);
                }
            }
            res.put(MACRO_NAME, AgentURLMacroProvider.generateDownloadMacroValue(remotingURL));
            return res;
        }

        @Nonnull
        static String generateDownloadMacroValue(@CheckForNull URL remotingURL) {
            String macroValue;
            if (remotingURL != null) {
                macroValue = "<download from=\"" + remotingURL.toString() + "\" to=\"%BASE%\\slave.jar\"/>";
                if (!"https".equals(remotingURL.getProtocol())) {
                    macroValue = "<!-- " + macroValue + " -->";
                }
            } else {
                macroValue = DEFAULT_DISABLED_VALUE;
            }
            return macroValue;
        }

        @Override
        public Set<String> getMacroNames() {
            return Collections.unmodifiableSet(MACRO_NAMES);
        }

        @Override
        public String getDefaulValue(String macroName) {
            if (MACRO_NAMES.contains(macroName)) {
                return DEFAULT_DISABLED_VALUE;
            }
            return null;
        }
    }

    static class ServiceStarterThread
    extends Thread {
        private final File agentExe;
        private final File rootDir;
        private final String serviceId;

        public ServiceStarterThread(@Nonnull File agentExe, @Nonnull File rootDir, @Nonnull String serviceId) {
            super("Service Starter for " + serviceId);
            this.agentExe = agentExe;
            this.rootDir = rootDir;
            this.serviceId = serviceId;
        }

        @Override
        public void run() {
            try {
                StreamTaskListener task = StreamTaskListener.fromStdout();
                int r = WindowsSlaveInstaller.runElevated(this.agentExe, "start", (TaskListener)task, this.rootDir);
                task.getLogger().println(r == 0 ? "Successfully started" : "Start service failed. Exit code=" + r);
            }
            catch (IOException | InterruptedException ex) {
                LOGGER.log(Level.SEVERE, "Failed to start the service with id=" + this.serviceId, ex);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    static abstract class MacroValueProvider {
        MacroValueProvider() {
        }

        @Nonnull
        public abstract Map<String, String> getMacroValues();

        @Nonnull
        public abstract Set<String> getMacroNames();

        @CheckForNull
        public abstract String getDefaulValue(@Nonnull String var1);

        static final Collection<MacroValueProvider> allDefaultProviders() {
            return Arrays.asList(new AgentURLMacroProvider(null));
        }
    }
}

