/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.modules.windows_slave_installer;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Callable;
import jenkins.model.Jenkins;
import org.jenkinsci.modules.windows_slave_installer.WindowsSlaveInstaller;

@Extension
public class SlaveExeUpdater
extends ComputerListener {
    private volatile String ourCopy;

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public void onOnline(Computer c, final TaskListener listener) throws IOException, InterruptedException {
        if (!(c instanceof SlaveComputer)) {
            return;
        }
        final SlaveComputer sc = (SlaveComputer)c;
        Jenkins.MasterComputer.threadPoolForRemoting.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    Channel ch = sc.getChannel();
                    Slave n = sc.getNode();
                    if (n == null || ch == null) {
                        return null;
                    }
                    FilePath root = new FilePath((VirtualChannel)ch, n.getRemoteFS());
                    FilePath slaveExe = root.child("jenkins-slave.exe");
                    if (!slaveExe.exists()) {
                        return null;
                    }
                    String current = slaveExe.digest();
                    URL ourExe = WindowsSlaveInstaller.class.getResource("jenkins-slave.exe");
                    if (SlaveExeUpdater.this.ourCopy == null) {
                        SlaveExeUpdater.this.ourCopy = Util.getDigestOf((InputStream)ourExe.openStream());
                    }
                    if (SlaveExeUpdater.this.ourCopy.equals(current)) {
                        return null;
                    }
                    FilePath tmp = new FilePath(slaveExe.getChannel(), slaveExe.getRemote() + ".new");
                    FilePath backup = new FilePath(slaveExe.getChannel(), slaveExe.getRemote() + ".bak");
                    if (backup.exists()) {
                        try {
                            backup.delete();
                        }
                        catch (IOException e) {
                            listener.getLogger().println("Looks like jenkins-slave.exe.bak is currently running. aborting overwrite");
                            return null;
                        }
                    }
                    tmp.copyFrom(ourExe);
                    slaveExe.renameTo(backup);
                    tmp.renameTo(slaveExe);
                    listener.getLogger().println("Scheduled overwrite of jenkins-slave.exe on the next service startup");
                }
                catch (Throwable e) {
                    e.printStackTrace(listener.error("Failed to update jenkins-slave.exe"));
                }
                return null;
            }
        });
    }
}

