/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.modules.slave_installer.impl;

import hudson.FilePath;
import hudson.Util;
import hudson.remoting.Callable;
import hudson.remoting.Engine;
import hudson.remoting.jnlp.MainDialog;
import hudson.remoting.jnlp.MainMenu;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jenkinsci.modules.slave_installer.InstallationException;
import org.jenkinsci.modules.slave_installer.LaunchConfiguration;
import org.jenkinsci.modules.slave_installer.SlaveInstaller;
import org.jenkinsci.modules.slave_installer.impl.JnlpLaunchConfiguration;
import org.jenkinsci.modules.slave_installer.impl.SwingPrompter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerGui
implements Callable<Void, IOException> {
    private final SlaveInstaller installer;
    private final FilePath slaveRoot;
    private transient Engine engine;
    private transient MainDialog dialog;
    private static final long serialVersionUID = 1L;
    public static LaunchConfiguration LAUNCH_CONFIG;

    public InstallerGui(SlaveInstaller installer, FilePath slaveRoot) {
        this.installer = installer;
        this.slaveRoot = slaveRoot;
    }

    public Void call() throws IOException {
        this.dialog = MainDialog.get();
        if (this.dialog == null) {
            return null;
        }
        this.engine = Engine.current();
        if (this.engine == null) {
            return null;
        }
        final URL jnlpUrl = new URL(this.engine.getHudsonUrl(), "computer/" + Util.rawEncode((String)this.engine.slaveName) + "/slave-agent.jnlp");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MainMenu mainMenu = InstallerGui.this.dialog.getMainMenu();
                JMenu m = mainMenu.getFileMenu();
                JMenuItem menu = new JMenuItem(InstallerGui.this.installer.getDisplayName());
                menu.addActionListener(new ActionListener(){
                    private Exception problem;

                    public void actionPerformed(ActionEvent e) {
                        try {
                            int r = JOptionPane.showConfirmDialog((Component)InstallerGui.this.dialog, InstallerGui.this.installer.getConfirmationText(), InstallerGui.this.installer.getDisplayName(), 2);
                            if (r != 0) {
                                return;
                            }
                            InstallerGui.this.dialog.setCursor(Cursor.getPredefinedCursor(3));
                            Thread t = new Thread("installer"){

                                public void run() {
                                    problem = null;
                                    LaunchConfiguration config = LAUNCH_CONFIG;
                                    if (config == null) {
                                        assert (!InstallerGui.this.slaveRoot.isRemote());
                                        config = new JnlpLaunchConfiguration(jnlpUrl, new File(InstallerGui.this.slaveRoot.getRemote()));
                                    }
                                    try {
                                        InstallerGui.this.installer.install(config, new SwingPrompter());
                                    }
                                    catch (Exception e) {
                                        problem = e;
                                    }
                                }
                            };
                            t.run();
                            t.join();
                            if (this.problem != null) {
                                throw this.problem;
                            }
                        }
                        catch (InstallationException t) {
                            JOptionPane.showMessageDialog((Component)InstallerGui.this.dialog, t.getMessage(), "Error", 0);
                        }
                        catch (Exception t) {
                            StringWriter sw = new StringWriter();
                            t.printStackTrace(new PrintWriter(sw));
                            JOptionPane.showMessageDialog((Component)InstallerGui.this.dialog, sw.toString(), "Error", 0);
                        }
                    }
                });
                m.add(menu);
                mainMenu.commit();
            }
        });
        return null;
    }
}

