/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class RemoteInputStream
extends InputStream
implements Serializable {
    private transient InputStream core;
    private boolean autoUnexport;
    private static final long serialVersionUID = 1L;

    public RemoteInputStream(InputStream core) {
        this(core, true);
    }

    public RemoteInputStream(InputStream core, boolean autoUnexport) {
        this.core = core;
        this.autoUnexport = autoUnexport;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int id = Channel.current().export(this.core, this.autoUnexport);
        oos.writeInt(id);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Channel channel = Channel.current();
        assert (channel != null);
        this.core = new ProxyInputStream(channel, ois.readInt());
    }

    public int read() throws IOException {
        return this.core.read();
    }

    public int read(byte[] b) throws IOException {
        return this.core.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.core.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        return this.core.skip(n);
    }

    public int available() throws IOException {
        return this.core.available();
    }

    public void close() throws IOException {
        this.core.close();
    }

    public void mark(int readlimit) {
        this.core.mark(readlimit);
    }

    public void reset() throws IOException {
        this.core.reset();
    }

    public boolean markSupported() {
        return this.core.markSupported();
    }
}

