/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.Command;
import hudson.remoting.FastPipedInputStream;
import hudson.remoting.FastPipedOutputStream;
import hudson.remoting.ProxyOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Pipe
implements Serializable {
    private InputStream in;
    private OutputStream out;
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Pipe.class.getName());

    private Pipe(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    public InputStream getIn() {
        return this.in;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public static Pipe createRemoteToLocal() {
        return new Pipe(new FastPipedInputStream(), null);
    }

    public static Pipe createLocalToRemote() {
        return new Pipe(null, new ProxyOutputStream());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.in != null && this.out == null) {
            FastPipedOutputStream pos = new FastPipedOutputStream((FastPipedInputStream)this.in);
            int oid = Channel.current().export(pos, false);
            oos.writeBoolean(true);
            oos.writeInt(oid);
        } else {
            int oid = Channel.current().export(this.out, false);
            oos.writeBoolean(false);
            oos.writeInt(oid);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Channel channel = Channel.current();
        assert (channel != null);
        if (ois.readBoolean()) {
            this.in = null;
            this.out = new ProxyOutputStream(channel, ois.readInt());
        } else {
            int oidRos = ois.readInt();
            FastPipedOutputStream pos = new FastPipedOutputStream();
            FastPipedInputStream pis = new FastPipedInputStream(pos);
            int oidPos = channel.export(pos, false);
            channel.send(new ConnectCommand(oidRos, oidPos));
            this.out = null;
            this.in = pis;
        }
    }

    private static class ConnectCommand
    extends Command {
        private final int oidRos;
        private final int oidPos;
        static final long serialVersionUID = -9128735897846418140L;

        public ConnectCommand(int oidRos, int oidPos) {
            this.oidRos = oidRos;
            this.oidPos = oidPos;
        }

        protected void execute(final Channel channel) {
            channel.pipeWriter.submit(new Runnable(){

                public void run() {
                    try {
                        ProxyOutputStream ros = (ProxyOutputStream)channel.getExportedObject(ConnectCommand.this.oidRos);
                        channel.unexport(ConnectCommand.this.oidRos);
                        ros.connect(channel, ConnectCommand.this.oidPos);
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "Failed to connect to pipe", e);
                    }
                }
            });
        }
    }
}

