/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ExportTable<T> {
    private final Map<Integer, Entry> table = new HashMap<Integer, Entry>();
    private final Map<T, Entry> reverse = new HashMap<T, Entry>();
    private final ThreadLocal<ExportList> lists = new ThreadLocal();
    private int iota = 1;

    ExportTable() {
    }

    public ExportList startRecording() {
        ExportList el = new ExportList();
        this.lists.set(el);
        return el;
    }

    public boolean isRecording() {
        return this.lists.get() != null;
    }

    public synchronized int export(T t) {
        return this.export(t, true);
    }

    public synchronized int export(T t, boolean notifyListener) {
        ExportList l;
        if (t == null) {
            return 0;
        }
        Entry e = this.reverse.get(t);
        if (e == null) {
            e = new Entry(t);
        }
        e.addRef();
        if (notifyListener && (l = this.lists.get()) != null) {
            l.add(e);
        }
        return e.id;
    }

    synchronized void pin(T t) {
        Entry e = this.reverse.get(t);
        if (e == null) {
            e = new Entry(t);
        }
        e.pin();
    }

    public synchronized T get(int id) {
        Entry e = this.table.get(id);
        if (e != null) {
            return e.object;
        }
        return null;
    }

    public synchronized void unexport(T t) {
        if (t == null) {
            return;
        }
        Entry e = this.reverse.get(t);
        if (e == null) {
            return;
        }
        e.release();
    }

    public synchronized void unexportByOid(Integer oid) {
        if (oid == null) {
            return;
        }
        Entry e = this.table.get(oid);
        if (e == null) {
            return;
        }
        e.release();
    }

    public synchronized void dump(PrintWriter w) throws IOException {
        for (Entry e : this.table.values()) {
            w.printf("#%d (ref.%d) : %s\n", e.id, e.referenceCount, e.object);
            e.allocationTrace.printStackTrace(w);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ExportList
    extends ArrayList<Entry> {
        private final ExportList old;

        private ExportList() {
            this.old = (ExportList)ExportTable.this.lists.get();
            ExportTable.this.lists.set(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release() {
            ExportTable exportTable = ExportTable.this;
            synchronized (exportTable) {
                for (Entry e : this) {
                    e.release();
                }
            }
        }

        void stopRecording() {
            ExportTable.this.lists.set(this.old);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Entry {
        final int id;
        final T object;
        final Exception allocationTrace;
        private int referenceCount;

        Entry(T object) {
            this.id = ExportTable.this.iota++;
            this.object = object;
            this.allocationTrace = new Exception();
            this.allocationTrace.getStackTrace();
            ExportTable.this.table.put(this.id, this);
            ExportTable.this.reverse.put(object, this);
        }

        void addRef() {
            ++this.referenceCount;
        }

        void pin() {
            this.referenceCount += 0x3FFFFFFF;
        }

        void release() {
            if (--this.referenceCount == 0) {
                ExportTable.this.table.remove(this.id);
                ExportTable.this.reverse.remove(this.object);
            }
        }
    }
}

