/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client;

import io.jenkins.cli.shaded.jakarta.websocket.ClientEndpointConfig;
import io.jenkins.cli.shaded.jakarta.websocket.DeploymentException;
import io.jenkins.cli.shaded.org.glassfish.tyrus.client.SslContextConfigurator;
import io.jenkins.cli.shaded.org.glassfish.tyrus.client.ThreadPoolConfig;
import io.jenkins.cli.shaded.org.glassfish.tyrus.client.exception.Exceptions;
import io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client.ClientFilter;
import io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client.Filter;
import io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client.SslEngineConfigurator;
import io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client.SslFilter;
import io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client.TaskQueueFilter;
import io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client.TransportFilter;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.ReflectionHelper;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.Utils;
import io.jenkins.cli.shaded.org.glassfish.tyrus.spi.ClientContainer;
import io.jenkins.cli.shaded.org.glassfish.tyrus.spi.ClientEngine;
import io.jenkins.cli.shaded.org.glassfish.tyrus.spi.CompletionHandler;
import io.jenkins.cli.shaded.org.glassfish.tyrus.spi.UpgradeRequest;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;

public class JdkClientContainer
implements ClientContainer {
    private static final int SSL_INPUT_BUFFER_SIZE = 17000;
    private static final int INPUT_BUFFER_SIZE = 2048;
    private static final Logger LOGGER = Logger.getLogger(JdkClientContainer.class.getName());

    @Override
    public void openClientSocket(final ClientEndpointConfig cec, final Map<String, Object> properties, final ClientEngine clientEngine) throws DeploymentException, IOException {
        String wlsMaxThreadsStr;
        ThreadPoolConfig threadPoolConfig = Utils.getProperty(properties, "io.jenkins.cli.shaded.org.glassfish.tyrus.client.workerThreadPoolConfig", ThreadPoolConfig.class);
        if (threadPoolConfig == null) {
            threadPoolConfig = ThreadPoolConfig.defaultConfig();
        }
        if ((wlsMaxThreadsStr = System.getProperty("weblogic.websocket.client.max-aio-threads")) != null) {
            try {
                int wlsMaxThreads = Integer.parseInt(wlsMaxThreadsStr);
                threadPoolConfig.setMaxPoolSize(wlsMaxThreads);
            }
            catch (Exception e) {
                LOGGER.log(Level.CONFIG, String.format("Invalid type of configuration property of %s , %s cannot be cast to Integer", "weblogic.websocket.client.max-aio-threads", wlsMaxThreadsStr));
            }
        }
        final Integer containerIdleTimeout = Utils.getProperty(properties, "io.jenkins.cli.shaded.org.glassfish.tyrus.client.sharedContainerIdleTimeout", Integer.class);
        final InetAddress bindingAddress = Utils.getProperty(properties, "io.jenkins.cli.shaded.org.glassfish.tyrus.client.socketBinding", InetAddress.class);
        final ThreadPoolConfig finalThreadPoolConfig = threadPoolConfig;
        Callable<Void> jdkConnector = new Callable<Void>(){

            @Override
            public Void call() throws DeploymentException {
                TaskQueueFilter writeQueue;
                TransportFilter transportFilter;
                TimeoutHandlerProxy timeoutHandlerProxy = new TimeoutHandlerProxy();
                UpgradeRequest upgradeRequest = clientEngine.createUpgradeRequest(timeoutHandlerProxy);
                URI uri = upgradeRequest.getRequestURI();
                List<Proxy> proxies = JdkClientContainer.this.processProxy(properties, uri);
                boolean secure = "wss".equalsIgnoreCase(uri.getScheme());
                if (secure) {
                    transportFilter = JdkClientContainer.this.createTransportFilter(17000, finalThreadPoolConfig, containerIdleTimeout, bindingAddress);
                    SslFilter sslFilter = JdkClientContainer.this.createSslFilter(cec, properties, transportFilter, uri);
                    writeQueue = JdkClientContainer.this.createTaskQueueFilter(sslFilter);
                } else {
                    transportFilter = JdkClientContainer.this.createTransportFilter(2048, finalThreadPoolConfig, containerIdleTimeout, bindingAddress);
                    writeQueue = JdkClientContainer.this.createTaskQueueFilter(transportFilter);
                }
                ClientFilter clientFilter = JdkClientContainer.this.createClientFilter(properties, writeQueue, clientEngine, this, upgradeRequest);
                timeoutHandlerProxy.setHandler(new ClientEngine.TimeoutHandler(){

                    @Override
                    public void handleTimeout() {
                        writeQueue.close();
                    }
                });
                Throwable exception = null;
                for (Proxy proxy : proxies) {
                    if (proxy.type() == Proxy.Type.DIRECT) {
                        SocketAddress serverAddress = JdkClientContainer.this.getServerAddress(uri);
                        try {
                            JdkClientContainer.this.connectSynchronously(clientFilter, serverAddress, false);
                            return null;
                        }
                        catch (Throwable throwable) {
                            exception = throwable;
                        }
                    }
                    LOGGER.log(Level.CONFIG, String.format("Connecting to '%s' via proxy '%s'.", uri, proxy));
                    SocketAddress proxyAddress = proxy.address();
                    if (!(proxyAddress instanceof InetSocketAddress)) continue;
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)proxyAddress;
                    if (inetSocketAddress.isUnresolved()) {
                        proxyAddress = new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
                    }
                    try {
                        JdkClientContainer.this.connectSynchronously(clientFilter, proxyAddress, true);
                        return null;
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.FINE, "Connecting to " + String.valueOf(proxyAddress) + " failed", t);
                        clientFilter.close();
                        exception = t;
                    }
                }
                throw Exceptions.deploymentException("Connection failed.", exception);
            }
        };
        try {
            jdkConnector.call();
        }
        catch (Exception e) {
            if (e instanceof DeploymentException) {
                throw (DeploymentException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw Exceptions.deploymentException(e.getMessage(), e);
        }
    }

    private SslFilter createSslFilter(ClientEndpointConfig cec, Map<String, Object> properties, TransportFilter transportFilter, URI uri) {
        Object sslEngineConfiguratorObject = properties.get("io.jenkins.cli.shaded.org.glassfish.tyrus.client.sslEngineConfigurator");
        SslFilter sslFilter = null;
        if (sslEngineConfiguratorObject != null) {
            if (sslEngineConfiguratorObject instanceof io.jenkins.cli.shaded.org.glassfish.tyrus.client.SslEngineConfigurator) {
                sslFilter = new SslFilter((Filter)transportFilter, (io.jenkins.cli.shaded.org.glassfish.tyrus.client.SslEngineConfigurator)sslEngineConfiguratorObject, uri.getHost());
            } else if (sslEngineConfiguratorObject instanceof SslEngineConfigurator) {
                sslFilter = new SslFilter(transportFilter, (SslEngineConfigurator)sslEngineConfiguratorObject);
            } else if (cec.getSSLContext() != null) {
                sslFilter = new SslFilter((Filter)transportFilter, cec.getSSLContext(), uri.getHost());
            } else {
                LOGGER.log(Level.WARNING, "Invalid 'org.glassfish.tyrus.client.sslEngineConfigurator' property value: " + String.valueOf(sslEngineConfiguratorObject) + ". Using system defaults.");
            }
        }
        if (sslFilter == null) {
            String wlsIgnoreHostnameVerification;
            SslContextConfigurator defaultConfig = new SslContextConfigurator();
            defaultConfig.retrieve(System.getProperties());
            String wlsSslTrustStore = (String)cec.getUserProperties().get("weblogic.websocket.client.SSL_TRUSTSTORE");
            String wlsSslTrustStorePassword = (String)cec.getUserProperties().get("weblogic.websocket.client.SSL_TRUSTSTORE_PWD");
            if (wlsSslTrustStore != null) {
                defaultConfig.setTrustStoreFile(wlsSslTrustStore);
                if (wlsSslTrustStorePassword != null) {
                    defaultConfig.setTrustStorePassword(wlsSslTrustStorePassword);
                }
            }
            io.jenkins.cli.shaded.org.glassfish.tyrus.client.SslEngineConfigurator sslEngineConfigurator = new io.jenkins.cli.shaded.org.glassfish.tyrus.client.SslEngineConfigurator(defaultConfig, true, false, false);
            String wlsSslProtocols = (String)cec.getUserProperties().get("weblogic.websocket.client.SSL_PROTOCOLS");
            if (wlsSslProtocols != null) {
                sslEngineConfigurator.setEnabledProtocols(wlsSslProtocols.split(","));
            }
            if ("true".equalsIgnoreCase(wlsIgnoreHostnameVerification = System.getProperties().getProperty("weblogic.security.SSL.ignoreHostnameVerification"))) {
                sslEngineConfigurator.setHostVerificationEnabled(false);
            } else {
                Class hostnameVerifierClass;
                String className = System.getProperties().getProperty("weblogic.security.SSL.HostnameVerifier");
                if (className != null && !className.isEmpty() && (hostnameVerifierClass = ReflectionHelper.classForName(className)) != null) {
                    try {
                        HostnameVerifier hostnameVerifier = (HostnameVerifier)ReflectionHelper.getInstance(hostnameVerifierClass);
                        sslEngineConfigurator.setHostnameVerifier(hostnameVerifier);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        LOGGER.log(Level.INFO, String.format("Cannot instantiate class set as a value of '%s' property: %s", "weblogic.security.SSL.HostnameVerifier", className), e);
                    }
                }
            }
            sslFilter = new SslFilter((Filter)transportFilter, sslEngineConfigurator, uri.getHost());
        }
        return sslFilter;
    }

    private TransportFilter createTransportFilter(int sslInputBufferSize, ThreadPoolConfig threadPoolConfig, Integer containerIdleTimeout, InetAddress bindingAddress) {
        return new TransportFilter(sslInputBufferSize, threadPoolConfig, containerIdleTimeout, bindingAddress);
    }

    private TaskQueueFilter createTaskQueueFilter(Filter downstreamFilter) {
        return new TaskQueueFilter(downstreamFilter);
    }

    private ClientFilter createClientFilter(Map<String, Object> properties, Filter downstreamFilter, ClientEngine clientEngine, Callable<Void> jdkConnector, UpgradeRequest upgradeRequest) throws DeploymentException {
        return new ClientFilter(downstreamFilter, clientEngine, properties, jdkConnector, upgradeRequest);
    }

    private SocketAddress getServerAddress(URI uri) throws DeploymentException {
        int port = Utils.getWsPort(uri);
        try {
            return new InetSocketAddress(uri.getHost(), port);
        }
        catch (IllegalArgumentException e) {
            throw new DeploymentException(e.getMessage(), e);
        }
    }

    private void connectSynchronously(ClientFilter clientFilter, SocketAddress address, boolean proxy) throws Throwable {
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        final CountDownLatch connectLatch = new CountDownLatch(1);
        try {
            clientFilter.connect(address, proxy, new CompletionHandler<Void>(){

                @Override
                public void completed(Void result) {
                    connectLatch.countDown();
                }

                @Override
                public void failed(Throwable exc) {
                    exception.set(exc);
                    connectLatch.countDown();
                }
            });
            connectLatch.await();
            Throwable throwable = exception.get();
            if (throwable != null) {
                throw throwable;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new DeploymentException("The thread waiting for client to connect has been interrupted before the connection has finished", e);
        }
    }

    private List<Proxy> processProxy(Map<String, Object> properties, URI uri) throws DeploymentException {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        String wlsProxyHost = null;
        Integer wlsProxyPort = null;
        Object value = properties.get("weblogic.websocket.client.PROXY_HOST");
        if (value != null) {
            if (value instanceof String) {
                wlsProxyHost = (String)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_HOST only accept String values.");
            }
        }
        if ((value = properties.get("weblogic.websocket.client.PROXY_PORT")) != null) {
            if (value instanceof Integer) {
                wlsProxyPort = (Integer)value;
            } else {
                throw new DeploymentException("weblogic.websocket.client.PROXY_PORT only accept Integer values.");
            }
        }
        if (wlsProxyHost != null) {
            proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(wlsProxyHost, wlsProxyPort == null ? 80 : wlsProxyPort)));
        } else {
            Object proxyString = properties.get("io.jenkins.cli.shaded.org.glassfish.tyrus.client.proxy");
            try {
                if (proxyString != null) {
                    URI proxyUri = new URI(proxyString.toString());
                    if (proxyUri.getHost() == null) {
                        LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString));
                    } else {
                        int proxyPort = proxyUri.getPort() == -1 ? 80 : proxyUri.getPort();
                        proxies.add(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyPort)));
                    }
                }
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.WARNING, String.format("Invalid proxy '%s'.", proxyString), e);
            }
        }
        ProxySelector proxySelector = ProxySelector.getDefault();
        if (proxySelector != null) {
            this.addProxies(proxySelector, uri, "socket", proxies);
            this.addProxies(proxySelector, uri, "https", proxies);
            this.addProxies(proxySelector, uri, "http", proxies);
        }
        if (proxies.isEmpty()) {
            proxies.add(Proxy.NO_PROXY);
        }
        return proxies;
    }

    private void addProxies(ProxySelector proxySelector, URI uri, String scheme, List<Proxy> proxies) {
        for (Proxy p : proxySelector.select(this.getProxyUri(uri, scheme))) {
            switch (p.type()) {
                case HTTP: {
                    LOGGER.log(Level.FINE, String.format("Found proxy: '%s'", p));
                    proxies.add(p);
                    break;
                }
                case SOCKS: {
                    LOGGER.log(Level.INFO, String.format("Socks proxy is not supported, please file new issue at https://java.net/jira/browse/TYRUS. Proxy '%s' will be ignored.", p));
                    break;
                }
            }
        }
    }

    private URI getProxyUri(URI wsUri, String scheme) {
        try {
            return new URI(scheme, wsUri.getUserInfo(), wsUri.getHost(), wsUri.getPort(), wsUri.getPath(), wsUri.getQuery(), wsUri.getFragment());
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, String.format("Exception during generating proxy URI '%s'", wsUri), e);
            return wsUri;
        }
    }

    private static class TimeoutHandlerProxy
    implements ClientEngine.TimeoutHandler {
        private volatile ClientEngine.TimeoutHandler handler;

        private TimeoutHandlerProxy() {
        }

        @Override
        public void handleTimeout() {
            if (this.handler != null) {
                this.handler.handleTimeout();
            }
        }

        public void setHandler(ClientEngine.TimeoutHandler handler) {
            this.handler = handler;
        }
    }
}

