/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client;

import io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client.Filter;
import io.jenkins.cli.shaded.org.glassfish.tyrus.container.jdk.client.SslEngineConfigurator;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.Utils;
import io.jenkins.cli.shaded.org.glassfish.tyrus.spi.CompletionHandler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;

class SslFilter
extends Filter {
    private static final ByteBuffer emptyBuffer = ByteBuffer.allocate(0);
    private static final String TLSV13 = "TLSv1.3";
    private final ByteBuffer applicationInputBuffer;
    private final ByteBuffer networkOutputBuffer;
    private final SSLEngine sslEngine;
    private final HostnameVerifier customHostnameVerifier;
    private final String serverHost;
    private final WriteQueue writeQueue = new WriteQueue();
    private final Lock lock = new ReentrantLock();
    private volatile State state = State.NOT_STARTED;
    private volatile boolean tlsv13 = false;
    private Runnable pendingApplicationWrite = null;

    SslFilter(Filter downstreamFilter, io.jenkins.cli.shaded.org.glassfish.tyrus.client.SslEngineConfigurator sslEngineConfigurator, String serverHost) {
        super(downstreamFilter);
        this.serverHost = serverHost;
        this.sslEngine = sslEngineConfigurator.createSSLEngine(serverHost);
        this.customHostnameVerifier = sslEngineConfigurator.getHostnameVerifier();
        if (sslEngineConfigurator.isHostVerificationEnabled() && sslEngineConfigurator.getHostnameVerifier() == null) {
            SSLParameters sslParameters = this.sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            this.sslEngine.setSSLParameters(sslParameters);
        }
        this.applicationInputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.networkOutputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
    }

    SslFilter(Filter downstreamFilter, SSLContext sslContext, String serverHost) {
        this(downstreamFilter, new io.jenkins.cli.shaded.org.glassfish.tyrus.client.SslEngineConfigurator(sslContext), serverHost);
    }

    SslFilter(Filter downstreamFilter, SslEngineConfigurator sslEngineConfigurator) {
        super(downstreamFilter);
        this.sslEngine = sslEngineConfigurator.createSSLEngine();
        this.applicationInputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.networkOutputBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        this.customHostnameVerifier = null;
        this.serverHost = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    void write(ByteBuffer applicationData, CompletionHandler<ByteBuffer> completionHandler) {
        this.lock.lock();
        try {
            switch (this.state.ordinal()) {
                case 0: {
                    this.writeQueue.write(applicationData, completionHandler);
                    return;
                }
                case 1: {
                    completionHandler.failed(new IllegalStateException("Cannot write until SSL handshake has been completed"));
                    return;
                }
                case 2: {
                    this.storePendingApplicationWrite(applicationData, completionHandler);
                    return;
                }
                case 3: {
                    this.handleWrite(applicationData, completionHandler);
                    return;
                }
                case 4: {
                    completionHandler.failed(new IllegalStateException("SSL session has been closed"));
                    return;
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void handleWrite(final ByteBuffer applicationData, final CompletionHandler<ByteBuffer> completionHandler) {
        try {
            ((Buffer)this.networkOutputBuffer).clear();
            SSLEngineResult result = this.sslEngine.wrap(applicationData, this.networkOutputBuffer);
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    throw new IllegalStateException("SSL packet does not fit into the network buffer: " + String.valueOf(this.networkOutputBuffer) + "\n" + this.getDebugState());
                }
                case BUFFER_UNDERFLOW: {
                    throw new IllegalStateException("SSL engine underflow with the following application input: " + String.valueOf(applicationData) + "\n" + this.getDebugState());
                }
                case CLOSED: {
                    this.setState(State.CLOSED);
                    break;
                }
                case OK: {
                    if (this.isHandshaking(result.getHandshakeStatus())) {
                        this.setState(State.REHANDSHAKING);
                    }
                    ((Buffer)this.networkOutputBuffer).flip();
                    if (this.networkOutputBuffer.hasRemaining()) {
                        this.writeQueue.write(this.networkOutputBuffer, new CompletionHandler<ByteBuffer>(){

                            @Override
                            public void completed(ByteBuffer result) {
                                SslFilter.this.handlePostWrite(applicationData, completionHandler);
                            }

                            @Override
                            public void failed(Throwable throwable) {
                                completionHandler.failed(throwable);
                            }
                        });
                        break;
                    }
                    this.handlePostWrite(applicationData, completionHandler);
                }
            }
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }

    private void handlePostWrite(ByteBuffer applicationData, CompletionHandler<ByteBuffer> completionHandler) {
        this.lock.lock();
        try {
            if (this.state == State.REHANDSHAKING) {
                if (applicationData.hasRemaining()) {
                    this.storePendingApplicationWrite(applicationData, completionHandler);
                    this.doHandshakeStep(emptyBuffer);
                }
            } else if (applicationData.hasRemaining()) {
                this.handleWrite(applicationData, completionHandler);
            } else {
                completionHandler.completed(applicationData);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void storePendingApplicationWrite(final ByteBuffer applicationData, final CompletionHandler<ByteBuffer> completionHandler) {
        if (this.pendingApplicationWrite != null) {
            throw new IllegalStateException("Only one write operation can be in progress\n" + this.getDebugState());
        }
        this.pendingApplicationWrite = new Runnable(){

            @Override
            public void run() {
                SslFilter.this.write(applicationData, completionHandler);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void close() {
        block13: {
            this.lock.lock();
            try {
                if (this.state == State.NOT_STARTED) {
                    this.downstreamFilter.close();
                    return;
                }
                this.sslEngine.closeOutbound();
                try {
                    ByteBuffer buffer;
                    LazyBuffer lazyBuffer = new LazyBuffer();
                    while (this.sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                        buffer = lazyBuffer.get();
                        SSLEngineResult result = this.sslEngine.wrap(emptyBuffer, buffer);
                        switch (result.getStatus()) {
                            case BUFFER_OVERFLOW: {
                                lazyBuffer.resize();
                                break;
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new IllegalStateException("SSL engine underflow while close operation \n" + this.getDebugState());
                            }
                        }
                    }
                    if (lazyBuffer.isAllocated()) {
                        buffer = lazyBuffer.get();
                        ((Buffer)buffer).flip();
                        this.writeQueue.write(buffer, new CompletionHandler<ByteBuffer>(){

                            @Override
                            public void completed(ByteBuffer result) {
                                SslFilter.this.downstreamFilter.close();
                            }

                            @Override
                            public void failed(Throwable throwable) {
                                SslFilter.this.downstreamFilter.close();
                            }
                        });
                        break block13;
                    }
                    this.downstreamFilter.close();
                }
                catch (Exception e) {
                    this.handleSslError(e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    boolean processRead(ByteBuffer networkData) {
        boolean readMore = true;
        while (networkData.hasRemaining() && readMore) {
            switch (this.state.ordinal()) {
                case 0: {
                    return true;
                }
                case 1: 
                case 2: {
                    readMore = this.doHandshakeStep(networkData);
                    break;
                }
                case 3: {
                    readMore = this.handleRead(networkData);
                    break;
                }
                case 4: {
                    ((Buffer)networkData).clear();
                    readMore = false;
                }
            }
        }
        return false;
    }

    private boolean handleRead(ByteBuffer networkData) {
        try {
            ((Buffer)this.applicationInputBuffer).clear();
            SSLEngineResult result = this.sslEngine.unwrap(networkData, this.applicationInputBuffer);
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    throw new IllegalStateException("Contents of a SSL packet did not fit into buffer: " + String.valueOf(this.applicationInputBuffer) + "\n" + this.getDebugState());
                }
                case BUFFER_UNDERFLOW: {
                    return false;
                }
                case CLOSED: 
                case OK: {
                    if (result.bytesProduced() > 0) {
                        ((Buffer)this.applicationInputBuffer).flip();
                        this.upstreamFilter.onRead(this.applicationInputBuffer);
                        this.applicationInputBuffer.compact();
                    }
                    if (this.sslEngine.isInboundDone()) {
                        return false;
                    }
                    if (this.tlsv13 || !this.isHandshaking(result.getHandshakeStatus()) || this.sslEngine.isOutboundDone()) break;
                    this.setState(State.REHANDSHAKING);
                    return this.doHandshakeStep(networkData);
                }
            }
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doHandshakeStep(ByteBuffer networkData) {
        LazyBuffer inputBuffer = new LazyBuffer();
        boolean handshakeFinished = false;
        this.lock.lock();
        try {
            SSLEngineResult.HandshakeStatus hs = this.sslEngine.getHandshakeStatus();
            if (!this.isHandshaking(hs)) {
                boolean bl = true;
                return bl;
            }
            try {
                LazyBuffer outputBuffer = new LazyBuffer();
                boolean stepFinished = false;
                while (!stepFinished) {
                    hs = this.sslEngine.getHandshakeStatus();
                    block3 : switch (hs) {
                        case NOT_HANDSHAKING: {
                            throw new IllegalStateException("Trying to handshake, but SSL engine not in HANDSHAKING state.SSL filter state: \n" + this.getDebugState());
                        }
                        case FINISHED: {
                            throw new IllegalStateException("Trying to handshake, but SSL engine not in HANDSHAKING state.SSL filter state: \n" + this.getDebugState());
                        }
                        case NEED_WRAP: {
                            ByteBuffer byteBuffer = outputBuffer.get();
                            SSLEngineResult result = this.sslEngine.wrap(emptyBuffer, byteBuffer);
                            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                stepFinished = true;
                                handshakeFinished = true;
                            }
                            switch (result.getStatus()) {
                                case BUFFER_OVERFLOW: {
                                    outputBuffer.resize();
                                    break block3;
                                }
                                case BUFFER_UNDERFLOW: {
                                    throw new IllegalStateException("SSL engine underflow with the following SSL filter state: \n" + this.getDebugState());
                                }
                                case CLOSED: {
                                    stepFinished = true;
                                    this.setState(State.CLOSED);
                                }
                            }
                            break;
                        }
                        case NEED_UNWRAP: {
                            SSLEngineResult result = this.sslEngine.unwrap(networkData, this.applicationInputBuffer);
                            ((Buffer)this.applicationInputBuffer).flip();
                            if (this.applicationInputBuffer.hasRemaining()) {
                                inputBuffer.append(this.applicationInputBuffer);
                            }
                            this.applicationInputBuffer.compact();
                            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                stepFinished = true;
                                handshakeFinished = true;
                            }
                            switch (result.getStatus()) {
                                case BUFFER_OVERFLOW: {
                                    throw new IllegalStateException("SSL packet does not fit into the network buffer: " + this.getDebugState());
                                }
                                case BUFFER_UNDERFLOW: {
                                    stepFinished = true;
                                    break block3;
                                }
                                case CLOSED: {
                                    stepFinished = true;
                                    this.setState(State.CLOSED);
                                }
                            }
                            break;
                        }
                        case NEED_TASK: {
                            Runnable delegatedTask;
                            while ((delegatedTask = this.sslEngine.getDelegatedTask()) != null) {
                                delegatedTask.run();
                            }
                            break;
                        }
                    }
                }
                if (outputBuffer.isAllocated()) {
                    ByteBuffer buffer = outputBuffer.get();
                    ((Buffer)buffer).flip();
                    this.writeQueue.write(buffer, null);
                }
            }
            catch (Exception e) {
                this.handleSslError(e);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (inputBuffer.isAllocated()) {
            ByteBuffer buffer = inputBuffer.get();
            this.upstreamFilter.onRead(buffer);
        }
        if (handshakeFinished) {
            this.handleHandshakeFinished();
            this.tlsv13 = TLSV13.equals(this.sslEngine.getSession().getProtocol());
            return true;
        }
        return false;
    }

    private void handleHandshakeFinished() {
        if (this.customHostnameVerifier != null && !this.customHostnameVerifier.verify(this.serverHost, this.sslEngine.getSession())) {
            this.handleSslError(new SSLException("Server host name verification using " + String.valueOf(this.customHostnameVerifier.getClass()) + " has failed"));
            return;
        }
        if (this.state == State.HANDSHAKING) {
            this.setState(State.DATA);
            this.upstreamFilter.onSslHandshakeCompleted();
        } else if (this.state == State.REHANDSHAKING) {
            this.setState(State.DATA);
            if (this.pendingApplicationWrite != null) {
                Runnable write = this.pendingApplicationWrite;
                this.pendingApplicationWrite = null;
                write.run();
            }
        }
    }

    private void handleSslError(Throwable t) {
        this.onError(t);
    }

    @Override
    void startSsl() {
        try {
            this.setState(State.HANDSHAKING);
            this.sslEngine.beginHandshake();
            this.doHandshakeStep(emptyBuffer);
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }

    void rehandshake() {
        try {
            this.sslEngine.beginHandshake();
        }
        catch (SSLException e) {
            this.handleSslError(e);
        }
    }

    private String getDebugState() {
        return "SslFilter{\napplicationInputBuffer=" + String.valueOf(this.applicationInputBuffer) + ",\nnetworkOutputBuffer=" + String.valueOf(this.networkOutputBuffer) + ",\nsslEngineStatus=" + String.valueOf((Object)this.sslEngine.getHandshakeStatus()) + ",\nsslSession=" + String.valueOf(this.sslEngine.getSession()) + ",\nstate=" + String.valueOf((Object)this.state) + ",\npendingApplicationWrite=" + String.valueOf(this.pendingApplicationWrite) + ",\npendingWritesSize=" + String.valueOf(this.writeQueue) + "}";
    }

    private void setState(State state) {
        this.state = state;
    }

    private boolean isHandshaking(SSLEngineResult.HandshakeStatus hs) {
        return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING != hs && SSLEngineResult.HandshakeStatus.FINISHED != hs;
    }

    private class WriteQueue {
        private final Queue<Runnable> pendingWrites = new LinkedList<Runnable>();

        private WriteQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write(final ByteBuffer data, final CompletionHandler<ByteBuffer> completionHandler) {
            SslFilter.this.lock.lock();
            try {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        SslFilter.this.downstreamFilter.write(data, new CompletionHandler<ByteBuffer>(){

                            @Override
                            public void completed(ByteBuffer result) {
                                if (completionHandler != null) {
                                    completionHandler.completed(result);
                                }
                                WriteQueue.this.onWriteCompleted();
                            }

                            @Override
                            public void failed(Throwable throwable) {
                                if (completionHandler != null) {
                                    completionHandler.failed(throwable);
                                }
                                WriteQueue.this.onWriteCompleted();
                            }
                        });
                    }
                };
                this.pendingWrites.offer(r);
                if (this.pendingWrites.peek() == r) {
                    r.run();
                }
            }
            finally {
                SslFilter.this.lock.unlock();
            }
        }

        private void onWriteCompleted() {
            SslFilter.this.lock.lock();
            try {
                this.pendingWrites.poll();
                Runnable next = this.pendingWrites.peek();
                if (next != null) {
                    next.run();
                }
            }
            finally {
                SslFilter.this.lock.unlock();
            }
        }

        public String toString() {
            SslFilter.this.lock.lock();
            try {
                String string = "WriteQueue{pendingWrites=" + this.pendingWrites.size() + "}";
                return string;
            }
            finally {
                SslFilter.this.lock.unlock();
            }
        }
    }

    private static enum State {
        NOT_STARTED,
        HANDSHAKING,
        REHANDSHAKING,
        DATA,
        CLOSED;

    }

    private class LazyBuffer {
        private ByteBuffer buffer = null;

        private LazyBuffer() {
        }

        ByteBuffer get() {
            if (this.buffer == null) {
                this.buffer = ByteBuffer.allocate(SslFilter.this.sslEngine.getSession().getPacketBufferSize());
            }
            return this.buffer;
        }

        boolean isAllocated() {
            return this.buffer != null;
        }

        void resize() {
            int increment = SslFilter.this.sslEngine.getSession().getPacketBufferSize();
            int newSize = this.buffer.position() + increment;
            ByteBuffer newBuffer = ByteBuffer.allocate(newSize);
            ((Buffer)this.buffer).flip();
            ((Buffer)newBuffer).flip();
            this.buffer = Utils.appendBuffers(newBuffer, this.buffer, newBuffer.limit(), 50);
            this.buffer.compact();
        }

        void append(ByteBuffer b) {
            if (this.buffer == null) {
                this.buffer = ByteBuffer.allocate(b.remaining());
                ((Buffer)this.buffer).flip();
            }
            int newSize = this.buffer.limit() + b.remaining();
            this.buffer = Utils.appendBuffers(this.buffer, b, newSize, 50);
        }
    }
}

