/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa;

import io.jenkins.cli.shaded.org.bouncycastle.asn1.DERNull;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.CryptoServicesRegistrar;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import io.jenkins.cli.shaded.org.bouncycastle.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static final AlgorithmIdentifier PKCS_ALGID = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
    private static final AlgorithmIdentifier PSS_ALGID = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS);
    static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
    RSAKeyGenerationParameters param;
    RSAKeyPairGenerator engine;
    AlgorithmIdentifier algId;

    public KeyPairGeneratorSpi(String string, AlgorithmIdentifier algorithmIdentifier) {
        super(string);
        this.algId = algorithmIdentifier;
        this.engine = new RSAKeyPairGenerator();
        this.param = new RSAKeyGenerationParameters(defaultPublicExponent, CryptoServicesRegistrar.getSecureRandom(), 2048, PrimeCertaintyCalculator.getDefaultCertainty(2048));
        this.engine.init(this.param);
    }

    public KeyPairGeneratorSpi() {
        this("RSA", PKCS_ALGID);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.param = new RSAKeyGenerationParameters(defaultPublicExponent, secureRandom, n, PrimeCertaintyCalculator.getDefaultCertainty(n));
        this.engine.init(this.param);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
        }
        RSAKeyGenParameterSpec rSAKeyGenParameterSpec = (RSAKeyGenParameterSpec)algorithmParameterSpec;
        this.param = new RSAKeyGenerationParameters(rSAKeyGenParameterSpec.getPublicExponent(), secureRandom, rSAKeyGenParameterSpec.getKeysize(), PrimeCertaintyCalculator.getDefaultCertainty(2048));
        this.engine.init(this.param);
    }

    @Override
    public KeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricCipherKeyPair.getPublic();
        RSAPrivateCrtKeyParameters rSAPrivateCrtKeyParameters = (RSAPrivateCrtKeyParameters)asymmetricCipherKeyPair.getPrivate();
        return new KeyPair(new BCRSAPublicKey(this.algId, rSAKeyParameters), new BCRSAPrivateCrtKey(this.algId, rSAPrivateCrtKeyParameters));
    }

    public static class PSS
    extends KeyPairGeneratorSpi {
        public PSS() {
            super("RSASSA-PSS", PSS_ALGID);
        }
    }
}

