/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.crypto.prng;

import io.jenkins.cli.shaded.org.bouncycastle.crypto.prng.EntropySource;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.prng.EntropySourceProvider;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.prng.SP800SecureRandom;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.prng.X931SecureRandom;
import java.security.SecureRandom;

public class BasicEntropySourceProvider
implements EntropySourceProvider {
    private final SecureRandom _sr;
    private final boolean _predictionResistant;

    public BasicEntropySourceProvider(SecureRandom secureRandom, boolean bl) {
        this._sr = secureRandom;
        this._predictionResistant = bl;
    }

    @Override
    public EntropySource get(final int n) {
        return new EntropySource(){

            @Override
            public boolean isPredictionResistant() {
                return BasicEntropySourceProvider.this._predictionResistant;
            }

            @Override
            public byte[] getEntropy() {
                if (BasicEntropySourceProvider.this._sr instanceof SP800SecureRandom || BasicEntropySourceProvider.this._sr instanceof X931SecureRandom) {
                    byte[] byArray = new byte[(n + 7) / 8];
                    BasicEntropySourceProvider.this._sr.nextBytes(byArray);
                    return byArray;
                }
                return BasicEntropySourceProvider.this._sr.generateSeed((n + 7) / 8);
            }

            @Override
            public int entropySize() {
                return n;
            }
        };
    }
}

