/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.security.eddsa.generic;

import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.AbstractSignature;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.util.Map;

public class GenericSignatureEd25519
extends AbstractSignature {
    public GenericSignatureEd25519(String algorithm) {
        super(algorithm, "ssh-ed25519");
    }

    @Override
    public boolean verify(SessionContext session, byte[] sig) throws Exception {
        byte[] data = sig;
        Map.Entry<String, byte[]> encoding = this.extractEncodedSignature(data, "ssh-ed25519"::equalsIgnoreCase);
        if (encoding != null) {
            String keyType = encoding.getKey();
            ValidateUtils.checkTrue("ssh-ed25519".equals(keyType), "Mismatched key type: %s", (Object)keyType);
            data = encoding.getValue();
        }
        return this.doVerify(data);
    }
}

