/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.pqc.jcajce.provider.mceliece;

import io.jenkins.cli.shaded.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.Digest;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.util.DigestFactory;
import io.jenkins.cli.shaded.org.bouncycastle.internal.asn1.oiw.OIWObjectIdentifiers;

class Utils {
    Utils() {
    }

    static Digest getDigest(AlgorithmIdentifier algorithmIdentifier) {
        if (algorithmIdentifier.getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
            return DigestFactory.createSHA1();
        }
        if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
            return DigestFactory.createSHA224();
        }
        if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
            return DigestFactory.createSHA256();
        }
        if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha384)) {
            return DigestFactory.createSHA384();
        }
        if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha512)) {
            return DigestFactory.createSHA512();
        }
        throw new IllegalArgumentException("unrecognised OID in digest algorithm identifier: " + algorithmIdentifier.getAlgorithm());
    }
}

