/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.pqc.asn1;

import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1EncodableVector;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Integer;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Object;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Primitive;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.ASN1Sequence;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.DEROctetString;
import io.jenkins.cli.shaded.org.bouncycastle.asn1.DERSequence;
import io.jenkins.cli.shaded.org.bouncycastle.util.Arrays;

public class XMSSPublicKey
extends ASN1Object {
    private final byte[] publicSeed;
    private final byte[] root;

    public XMSSPublicKey(byte[] byArray, byte[] byArray2) {
        this.publicSeed = Arrays.clone(byArray);
        this.root = Arrays.clone(byArray2);
    }

    private XMSSPublicKey(ASN1Sequence aSN1Sequence) {
        if (!ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0)).hasValue(0)) {
            throw new IllegalArgumentException("unknown version of sequence");
        }
        this.publicSeed = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(1)).getOctets());
        this.root = Arrays.clone(DEROctetString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets());
    }

    public static XMSSPublicKey getInstance(Object object) {
        if (object instanceof XMSSPublicKey) {
            return (XMSSPublicKey)object;
        }
        if (object != null) {
            return new XMSSPublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public byte[] getPublicSeed() {
        return Arrays.clone(this.publicSeed);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.root);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(0L));
        aSN1EncodableVector.add(new DEROctetString(this.publicSeed));
        aSN1EncodableVector.add(new DEROctetString(this.root));
        return new DERSequence(aSN1EncodableVector);
    }
}

