/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.slf4j.jul;

import io.jenkins.cli.shaded.org.slf4j.ILoggerFactory;
import io.jenkins.cli.shaded.org.slf4j.Logger;
import io.jenkins.cli.shaded.org.slf4j.jul.JDK14LoggerAdapter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JDK14LoggerFactory
implements ILoggerFactory {
    ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();
    private static String JUL_ROOT_LOGGER_NAME = "";

    public JDK14LoggerFactory() {
        java.util.logging.Logger.getLogger("");
    }

    @Override
    public Logger getLogger(String name) {
        Logger slf4jLogger;
        if (name.equalsIgnoreCase("ROOT")) {
            name = JUL_ROOT_LOGGER_NAME;
        }
        if ((slf4jLogger = (Logger)this.loggerMap.get(name)) != null) {
            return slf4jLogger;
        }
        java.util.logging.Logger julLogger = java.util.logging.Logger.getLogger(name);
        JDK14LoggerAdapter newInstance = new JDK14LoggerAdapter(julLogger);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }
}

