/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers;

import io.jenkins.cli.shaded.org.apache.sshd.common.Service;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import java.util.Objects;

public class CurrentService {
    protected final Session session;
    private String currentName;
    private Service currentService;

    protected CurrentService(Session session) {
        this.session = Objects.requireNonNull(session, "No session given");
    }

    public synchronized String getName() {
        return this.currentName;
    }

    public synchronized Service getService() {
        return this.currentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Service service, String name, boolean start) {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No service name specified");
        Objects.requireNonNull(service, "No service specified");
        CurrentService currentService = this;
        synchronized (currentService) {
            this.currentName = name;
            this.currentService = service;
        }
        if (start) {
            service.start();
        }
    }

    public void start() {
        Service current = this.getService();
        ValidateUtils.checkState(current != null, "No current SSH service; cannot start");
        current.start();
    }

    public boolean process(int cmd, Buffer buffer) throws Exception {
        Service current = this.getService();
        if (current != null) {
            current.process(cmd, buffer);
            return true;
        }
        return false;
    }
}

