/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.pem;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.der.ASN1Object;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.der.ASN1Type;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.der.DERParser;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.List;

public class PKCS8PrivateKeyInfo {
    private BigInteger version;
    private List<Integer> algorithmIdentifier;
    private ASN1Object algorithmParameter;
    private ASN1Object privateKeyBytes;

    public PKCS8PrivateKeyInfo() {
    }

    public PKCS8PrivateKeyInfo(byte[] encBytes) throws IOException {
        this.decode(encBytes);
    }

    public PKCS8PrivateKeyInfo(DERParser parser) throws IOException {
        this(parser.readObject());
    }

    public PKCS8PrivateKeyInfo(ASN1Object privateKeyInfo) throws IOException {
        this.decode(privateKeyInfo);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public void setVersion(BigInteger version) {
        this.version = version;
    }

    public List<Integer> getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    public void setAlgorithmIdentifier(List<Integer> algorithmIdentifier) {
        this.algorithmIdentifier = algorithmIdentifier;
    }

    public ASN1Object getAlgorithmParameter() {
        return this.algorithmParameter;
    }

    public void setAlgorithmParameter(ASN1Object algorithmParameter) {
        this.algorithmParameter = algorithmParameter;
    }

    public ASN1Object getPrivateKeyBytes() {
        return this.privateKeyBytes;
    }

    public void setPrivateKeyBytes(ASN1Object privateKeyBytes) {
        this.privateKeyBytes = privateKeyBytes;
    }

    public void decode(byte[] encBytes) throws IOException {
        try (DERParser parser = new DERParser(encBytes);){
            this.decode(parser);
        }
    }

    public void decode(DERParser parser) throws IOException {
        this.decode(parser.readObject());
    }

    public void decode(ASN1Object privateKeyInfo) throws IOException {
        ASN1Type objType = privateKeyInfo.getObjType();
        if (objType != ASN1Type.SEQUENCE) {
            throw new StreamCorruptedException("Not a top level sequence: " + (Object)((Object)objType));
        }
        try (DERParser parser = privateKeyInfo.createParser();){
            ASN1Object versionObject = parser.readObject();
            if (versionObject == null) {
                throw new StreamCorruptedException("No version");
            }
            this.setVersion(versionObject.asInteger());
            ASN1Object privateKeyAlgorithm = parser.readObject();
            if (privateKeyAlgorithm == null) {
                throw new StreamCorruptedException("No private key algorithm");
            }
            objType = privateKeyInfo.getObjType();
            if (objType != ASN1Type.SEQUENCE) {
                throw new StreamCorruptedException("Not an algorithm parameters sequence: " + (Object)((Object)objType));
            }
            try (DERParser oidParser = privateKeyAlgorithm.createParser();){
                ASN1Object oid = oidParser.readObject();
                this.setAlgorithmIdentifier(oid.asOID());
                ASN1Object extraInfo = oidParser.readObject();
                ASN1Type aSN1Type = objType = extraInfo == null ? ASN1Type.NULL : extraInfo.getObjType();
                if (objType != ASN1Type.NULL) {
                    this.setAlgorithmParameter(extraInfo);
                }
            }
            ASN1Object privateKeyData = parser.readObject();
            if (privateKeyData == null) {
                throw new StreamCorruptedException("No private key data");
            }
            objType = privateKeyData.getObjType();
            if (objType != ASN1Type.OCTET_STRING) {
                throw new StreamCorruptedException("Private key data not an " + (Object)((Object)ASN1Type.OCTET_STRING) + ": " + (Object)((Object)objType));
            }
            this.setPrivateKeyBytes(privateKeyData);
        }
    }

    public void clear() {
        this.setVersion(null);
        this.setAlgorithmIdentifier(null);
        this.setPrivateKeyBytes(null);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[version=" + this.getVersion() + ", algorithmIdentifier=" + this.getAlgorithmIdentifier() + "]";
    }
}

