/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.bouncycastle.pqc.jcajce.provider.falcon;

import io.jenkins.cli.shaded.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.jcajce.interfaces.FalconPublicKey;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.jcajce.spec.FalconParameterSpec;
import io.jenkins.cli.shaded.org.bouncycastle.util.Arrays;
import io.jenkins.cli.shaded.org.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BCFalconPublicKey
implements FalconPublicKey {
    private static final long serialVersionUID = 1L;
    private transient FalconPublicKeyParameters params;
    private transient String algorithm;
    private transient byte[] encoding;

    public BCFalconPublicKey(FalconPublicKeyParameters falconPublicKeyParameters) {
        this.init(falconPublicKeyParameters);
    }

    public BCFalconPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init((FalconPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo));
    }

    private void init(FalconPublicKeyParameters falconPublicKeyParameters) {
        this.params = falconPublicKeyParameters;
        this.algorithm = Strings.toUpperCase(falconPublicKeyParameters.getParameters().getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCFalconPublicKey) {
            BCFalconPublicKey bCFalconPublicKey = (BCFalconPublicKey)object;
            return Arrays.areEqual(this.getEncoded(), bCFalconPublicKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = KeyUtil.getEncodedSubjectPublicKeyInfo(this.params);
        }
        return Arrays.clone(this.encoding);
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public FalconParameterSpec getParameterSpec() {
        return FalconParameterSpec.fromName(this.params.getParameters().getName());
    }

    FalconPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

