/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KeyEncapsulationMethod;
import io.jenkins.cli.shaded.org.apache.sshd.common.random.JceRandom;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.KeyGenerationParameters;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.SecretWithEncapsulation;
import io.jenkins.cli.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMExtractor;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKEMGenerator;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyGenerationParameters;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeKeyPairGenerator;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimeParameters;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePrivateKeyParameters;
import io.jenkins.cli.shaded.org.bouncycastle.pqc.crypto.ntruprime.SNTRUPrimePublicKeyParameters;
import java.util.Arrays;

final class SNTRUP761 {
    private SNTRUP761() {
    }

    static boolean isSupported() {
        if (SecurityUtils.isFipsMode()) {
            return false;
        }
        try {
            return SNTRUPrimeParameters.sntrup761.getSessionKeySize() == 256;
        }
        catch (Throwable e) {
            return false;
        }
    }

    static class Server
    implements KeyEncapsulationMethod.Server {
        private SecretWithEncapsulation value;

        Server() {
        }

        @Override
        public int getPublicKeyLength() {
            return SNTRUPrimeParameters.sntrup761.getPublicKeyBytes();
        }

        @Override
        public byte[] init(byte[] publicKey) {
            int pkBytes = this.getPublicKeyLength();
            if (publicKey.length < pkBytes) {
                throw new IllegalArgumentException("KEM public key too short: " + publicKey.length);
            }
            byte[] pk = Arrays.copyOf(publicKey, pkBytes);
            SNTRUPrimeKEMGenerator kemGenerator = new SNTRUPrimeKEMGenerator(JceRandom.getGlobalInstance());
            SNTRUPrimePublicKeyParameters params = new SNTRUPrimePublicKeyParameters(SNTRUPrimeParameters.sntrup761, pk);
            this.value = kemGenerator.generateEncapsulated((AsymmetricKeyParameter)params);
            return Arrays.copyOfRange(publicKey, pkBytes, publicKey.length);
        }

        @Override
        public byte[] getSecret() {
            return this.value.getSecret();
        }

        @Override
        public byte[] getEncapsulation() {
            return this.value.getEncapsulation();
        }
    }

    static class Client
    implements KeyEncapsulationMethod.Client {
        private SNTRUPrimeKEMExtractor extractor;
        private SNTRUPrimePublicKeyParameters publicKey;

        Client() {
        }

        @Override
        public void init() {
            SNTRUPrimeKeyPairGenerator gen = new SNTRUPrimeKeyPairGenerator();
            gen.init((KeyGenerationParameters)new SNTRUPrimeKeyGenerationParameters(JceRandom.getGlobalInstance(), SNTRUPrimeParameters.sntrup761));
            AsymmetricCipherKeyPair pair = gen.generateKeyPair();
            this.extractor = new SNTRUPrimeKEMExtractor((SNTRUPrimePrivateKeyParameters)pair.getPrivate());
            this.publicKey = (SNTRUPrimePublicKeyParameters)pair.getPublic();
        }

        @Override
        public byte[] getPublicKey() {
            return this.publicKey.getEncoded();
        }

        @Override
        public byte[] extractSecret(byte[] encapsulated) {
            if (encapsulated.length != this.extractor.getEncapsulationLength()) {
                throw new IllegalArgumentException("KEM encpsulation has wrong length: " + encapsulated.length);
            }
            return this.extractor.extractSecret(encapsulated);
        }

        @Override
        public int getEncapsulationLength() {
            return this.extractor.getEncapsulationLength();
        }
    }
}

