/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.cipher;

import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.BaseCipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.Cipher;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;

public class BaseCBCCipher
extends BaseCipher {
    private byte[] lastEncryptedBlock;

    public BaseCBCCipher(int ivsize, int authSize, int kdfSize, String algorithm, int keySize, String transformation, int blkSize) {
        super(ivsize, authSize, kdfSize, algorithm, keySize, transformation, blkSize);
    }

    @Override
    public void update(byte[] input, int inputOffset, int inputLen) throws Exception {
        if (this.mode == Cipher.Mode.Decrypt) {
            this.lastEncryptedBlock = Arrays.copyOfRange(input, inputOffset + inputLen - this.getCipherBlockSize(), inputOffset + inputLen);
        }
        super.update(input, inputOffset, inputLen);
    }

    @Override
    protected AlgorithmParameterSpec determineNewParameters(byte[] processed, int offset, int length) {
        if (this.mode == Cipher.Mode.Decrypt) {
            byte[] result = this.lastEncryptedBlock;
            this.lastEncryptedBlock = null;
            return new IvParameterSpec(result);
        }
        return new IvParameterSpec(Arrays.copyOfRange(processed, offset + length - this.getCipherBlockSize(), offset + length));
    }
}

