/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.OptionalFeature;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KeyEncapsulationMethod;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.MLKEM;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.SNTRUP761;

public enum BuiltinKEM implements KeyEncapsulationMethod,
NamedResource,
OptionalFeature
{
    mlkem768("mlkem768"){

        @Override
        public KeyEncapsulationMethod.Client getClient() {
            return MLKEM.getClient(MLKEM.Parameters.mlkem768);
        }

        @Override
        public KeyEncapsulationMethod.Server getServer() {
            return MLKEM.getServer(MLKEM.Parameters.mlkem768);
        }

        @Override
        public boolean isSupported() {
            return MLKEM.Parameters.mlkem768.isSupported();
        }
    }
    ,
    mlkem1024("mlkem1024"){

        @Override
        public KeyEncapsulationMethod.Client getClient() {
            return MLKEM.getClient(MLKEM.Parameters.mlkem1024);
        }

        @Override
        public KeyEncapsulationMethod.Server getServer() {
            return MLKEM.getServer(MLKEM.Parameters.mlkem1024);
        }

        @Override
        public boolean isSupported() {
            return MLKEM.Parameters.mlkem1024.isSupported();
        }
    }
    ,
    sntrup761("sntrup761"){

        @Override
        public KeyEncapsulationMethod.Client getClient() {
            return new SNTRUP761.Client();
        }

        @Override
        public KeyEncapsulationMethod.Server getServer() {
            return new SNTRUP761.Server();
        }

        @Override
        public boolean isSupported() {
            return SNTRUP761.isSupported();
        }
    };

    private String name;

    private BuiltinKEM(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

