/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.auth.pubkey;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import io.jenkins.cli.shaded.org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import io.jenkins.cli.shaded.org.apache.sshd.server.session.ServerSession;
import java.security.PublicKey;

public abstract class StaticPublickeyAuthenticator
extends AbstractLoggingBean
implements PublickeyAuthenticator {
    private final boolean acceptance;

    protected StaticPublickeyAuthenticator(boolean acceptance) {
        this.acceptance = acceptance;
    }

    public final boolean isAccepted() {
        return this.acceptance;
    }

    @Override
    public final boolean authenticate(String username, PublicKey key, ServerSession session) {
        boolean accepted = this.isAccepted();
        if (accepted) {
            this.handleAcceptance(username, key, session);
        }
        return accepted;
    }

    protected void handleAcceptance(String username, PublicKey key, ServerSession session) {
        this.log.warn("authenticate({}[{}][{}][{}]: accepted without checking", username, session, key == null ? "null" : key.getAlgorithm(), KeyUtils.getFingerPrint(key));
    }

    protected void handleRejection(String username, PublicKey key, ServerSession session) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("authenticate({}[{}][{}][{}]: rejected", username, session, key == null ? "null" : key.getAlgorithm(), KeyUtils.getFingerPrint(key));
        }
    }
}

