/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.agent.unix;

import io.jenkins.cli.shaded.org.apache.sshd.agent.SshAgent;
import io.jenkins.cli.shaded.org.apache.sshd.agent.SshAgentFactory;
import io.jenkins.cli.shaded.org.apache.sshd.agent.SshAgentServer;
import io.jenkins.cli.shaded.org.apache.sshd.agent.unix.AgentClient;
import io.jenkins.cli.shaded.org.apache.sshd.agent.unix.AgentServerProxy;
import io.jenkins.cli.shaded.org.apache.sshd.agent.unix.ChannelAgentForwardingFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.Factory;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.ConnectionService;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.CloseableExecutorService;
import io.jenkins.cli.shaded.org.apache.sshd.server.session.ServerSession;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class UnixAgentFactory
implements SshAgentFactory {
    public static final List<ChannelFactory> DEFAULT_FORWARDING_CHANNELS = Collections.unmodifiableList(Arrays.asList(ChannelAgentForwardingFactory.OPENSSH, ChannelAgentForwardingFactory.IETF));
    private Factory<CloseableExecutorService> executorServiceFactory;

    public UnixAgentFactory() {
    }

    public UnixAgentFactory(Factory<CloseableExecutorService> factory) {
        this.executorServiceFactory = factory;
    }

    protected CloseableExecutorService newExecutor() {
        return this.executorServiceFactory != null ? this.executorServiceFactory.create() : null;
    }

    @Override
    public List<ChannelFactory> getChannelForwardingFactories(FactoryManager manager) {
        if (this.executorServiceFactory != null) {
            return DEFAULT_FORWARDING_CHANNELS.stream().map(cf -> new ChannelAgentForwardingFactory(cf.getName(), this.executorServiceFactory)).collect(Collectors.toList());
        }
        return DEFAULT_FORWARDING_CHANNELS;
    }

    @Override
    public SshAgent createClient(Session session, FactoryManager manager) throws IOException {
        String authSocket = manager.getString("SSH_AUTH_SOCK");
        if (GenericUtils.isEmpty(authSocket)) {
            throw new SshException("No SSH_AUTH_SOCK value");
        }
        return new AgentClient(manager, authSocket, this.newExecutor());
    }

    @Override
    public SshAgentServer createServer(ConnectionService service) throws IOException {
        Session session = (Session)Objects.requireNonNull(service.getSession(), "No session");
        ValidateUtils.checkInstanceOf((Object)session, ServerSession.class, "The session used to create an agent server proxy must be a server session: %s", (Object)session);
        return new AgentServerProxy(service, this.newExecutor());
    }
}

