/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.auth;

import io.jenkins.cli.shaded.org.apache.sshd.client.auth.UserAuth;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.util.Objects;

public abstract class AbstractUserAuth
extends AbstractLoggingBean
implements UserAuth {
    private final String name;
    private ClientSession clientSession;
    private String service;
    private boolean cancellable;

    protected AbstractUserAuth(String name) {
        this.name = ValidateUtils.checkNotNullAndNotEmpty(name, "No name");
    }

    @Override
    public ClientSession getClientSession() {
        return this.clientSession;
    }

    @Override
    public ClientSession getSession() {
        return this.getClientSession();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String getService() {
        return this.service;
    }

    @Override
    public boolean isCancellable() {
        return this.cancellable;
    }

    protected void setCancellable(boolean cancellable) {
        this.cancellable = cancellable;
    }

    @Override
    public void init(ClientSession session, String service) throws Exception {
        this.clientSession = Objects.requireNonNull(session, "No client session");
        this.service = ValidateUtils.checkNotNullAndNotEmpty(service, "No service");
    }

    @Override
    public boolean process(Buffer buffer) throws Exception {
        ClientSession session = this.getClientSession();
        String service = this.getService();
        if (buffer == null) {
            return this.sendAuthDataRequest(session, service);
        }
        return this.processAuthDataRequest(session, service, buffer);
    }

    protected abstract boolean sendAuthDataRequest(ClientSession var1, String var2) throws Exception;

    protected abstract boolean processAuthDataRequest(ClientSession var1, String var2, Buffer var3) throws Exception;

    @Override
    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("destroy({})[{}]", (Object)this.getClientSession(), (Object)this.getService());
        }
    }

    public String toString() {
        return this.getName() + ": " + this.getSession() + "[" + this.getService() + "]";
    }
}

