/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.cipher;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.BaseCBCCipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.BaseCTRCipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.BaseCipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.BaseGCMCipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.BaseRC4Cipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.ChaCha20Cipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.Cipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.CipherFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.CipherNone;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.NamedFactoriesListParseResult;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum BuiltinCiphers implements CipherFactory
{
    none("none", 0, 0, 0, "None", 0, "None", 8){

        @Override
        public Cipher create() {
            return new CipherNone();
        }
    }
    ,
    aes128cbc("aes128-cbc", 16, 0, 16, "AES", 128, "AES/CBC/NoPadding", 16){

        @Override
        public Cipher create() {
            return new BaseCBCCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
        }
    }
    ,
    aes128ctr("aes128-ctr", 16, 0, 16, "AES", 128, "AES/CTR/NoPadding", 16){

        @Override
        public Cipher create() {
            return new BaseCTRCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
        }
    }
    ,
    aes128gcm("aes128-gcm@openssh.com", 12, 16, 16, "AES", 128, "AES/GCM/NoPadding", 16){

        @Override
        public Cipher create() {
            return new BaseGCMCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
        }
    }
    ,
    aes256gcm("aes256-gcm@openssh.com", 12, 16, 32, "AES", 256, "AES/GCM/NoPadding", 16){

        @Override
        public Cipher create() {
            return new BaseGCMCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
        }
    }
    ,
    aes192cbc("aes192-cbc", 16, 0, 24, "AES", 192, "AES/CBC/NoPadding", 16){

        @Override
        public Cipher create() {
            return new BaseCBCCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
        }
    }
    ,
    aes192ctr("aes192-ctr", 16, 0, 24, "AES", 192, "AES/CTR/NoPadding", 16){

        @Override
        public Cipher create() {
            return new BaseCTRCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
        }
    }
    ,
    aes256cbc("aes256-cbc", 16, 0, 32, "AES", 256, "AES/CBC/NoPadding", 16){

        @Override
        public Cipher create() {
            return new BaseCBCCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
        }
    }
    ,
    aes256ctr("aes256-ctr", 16, 0, 32, "AES", 256, "AES/CTR/NoPadding", 16){

        @Override
        public Cipher create() {
            return new BaseCTRCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
        }
    }
    ,
    arcfour128("arcfour128", 8, 0, 16, "ARCFOUR", 128, "RC4", 8){

        @Override
        public Cipher create() {
            return new BaseRC4Cipher(this.getIVSize(), this.getKdfSize(), this.getKeySize(), this.getCipherBlockSize());
        }
    }
    ,
    arcfour256("arcfour256", 8, 0, 32, "ARCFOUR", 256, "RC4", 8){

        @Override
        public Cipher create() {
            return new BaseRC4Cipher(this.getIVSize(), this.getKdfSize(), this.getKeySize(), this.getCipherBlockSize());
        }
    }
    ,
    blowfishcbc("blowfish-cbc", 8, 0, 16, "Blowfish", 128, "Blowfish/CBC/NoPadding", 8){

        @Override
        public Cipher create() {
            return new BaseCBCCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
        }
    }
    ,
    cc20p1305_openssh("chacha20-poly1305@openssh.com", 8, 16, 64, "ChaCha", 256, "ChaCha", 8){

        @Override
        public Cipher create() {
            return new ChaCha20Cipher();
        }
    }
    ,
    tripledescbc("3des-cbc", 8, 0, 24, "DESede", 192, "DESede/CBC/NoPadding", 8){

        @Override
        public Cipher create() {
            return new BaseCBCCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
        }
    };

    public static final Set<BuiltinCiphers> VALUES;
    private static final Map<String, CipherFactory> EXTENSIONS;
    private final String factoryName;
    private final int ivsize;
    private final int authSize;
    private final int kdfSize;
    private final int keysize;
    private final int blkSize;
    private final String algorithm;
    private final String transformation;
    private final boolean supported;

    private BuiltinCiphers(String factoryName, int ivsize, int authSize, int kdfSize, String algorithm, int keySize, String transformation, int blkSize) {
        this.factoryName = factoryName;
        this.ivsize = ivsize;
        this.authSize = authSize;
        this.kdfSize = kdfSize;
        this.keysize = keySize;
        this.algorithm = algorithm;
        this.transformation = transformation;
        this.blkSize = blkSize;
        this.supported = "none".equals(factoryName) || Cipher.checkSupported(this.transformation, this.keysize);
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public boolean isSupported() {
        return this.supported;
    }

    @Override
    public int getKeySize() {
        return this.keysize;
    }

    @Override
    public int getIVSize() {
        return this.ivsize;
    }

    @Override
    public int getAuthenticationTagSize() {
        return this.authSize;
    }

    @Override
    public int getKdfSize() {
        return this.kdfSize;
    }

    @Override
    public int getCipherBlockSize() {
        return this.blkSize;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getTransformation() {
        return this.transformation;
    }

    @Override
    public Cipher create() {
        return new BaseCipher(this.getIVSize(), this.getAuthenticationTagSize(), this.getKdfSize(), this.getAlgorithm(), this.getKeySize(), this.getTransformation(), this.getCipherBlockSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(CipherFactory extension) {
        String name = Objects.requireNonNull(extension, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinCiphers.fromFactoryName(name) == null, "Extension overrides built-in: %s", (Object)name);
        Map<String, CipherFactory> map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(name), "Extension overrides existing: %s", (Object)name);
            EXTENSIONS.put(name, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet<CipherFactory> getRegisteredExtensions() {
        Map<String, CipherFactory> map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedFactory<Cipher> unregisterExtension(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        Map<String, CipherFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.remove(name);
        }
    }

    public static BuiltinCiphers fromString(String s) {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        for (BuiltinCiphers c : VALUES) {
            if (!s.equalsIgnoreCase(c.name())) continue;
            return c;
        }
        return null;
    }

    public static BuiltinCiphers fromFactory(NamedFactory<Cipher> factory) {
        if (factory == null) {
            return null;
        }
        return BuiltinCiphers.fromFactoryName(factory.getName());
    }

    public static BuiltinCiphers fromFactoryName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static ParseResult parseCiphersList(String ciphers) {
        return BuiltinCiphers.parseCiphersList(GenericUtils.split(ciphers, ','));
    }

    public static ParseResult parseCiphersList(String ... ciphers) {
        return BuiltinCiphers.parseCiphersList(GenericUtils.isEmpty((Object[])ciphers) ? Collections.emptyList() : Arrays.asList(ciphers));
    }

    public static ParseResult parseCiphersList(Collection<String> ciphers) {
        if (GenericUtils.isEmpty(ciphers)) {
            return ParseResult.EMPTY;
        }
        ArrayList<CipherFactory> factories = new ArrayList<CipherFactory>(ciphers.size());
        List<String> unknown = Collections.emptyList();
        for (String name : ciphers) {
            CipherFactory c = BuiltinCiphers.resolveFactory(name);
            if (c != null) {
                factories.add(c);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult((List<CipherFactory>)factories, unknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CipherFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        BuiltinCiphers c = BuiltinCiphers.fromFactoryName(name);
        if (c != null) {
            return c;
        }
        Map<String, CipherFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.get(name);
        }
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinCiphers.class));
        EXTENSIONS = new TreeMap<String, CipherFactory>(String.CASE_INSENSITIVE_ORDER);
    }

    public static final class Constants {
        public static final String NONE = "none";
        public static final Pattern NONE_CIPHER_PATTERN = Pattern.compile("(^|.*,)none($|,.*)");
        public static final String AES128_CBC = "aes128-cbc";
        public static final String AES128_CTR = "aes128-ctr";
        public static final String AES128_GCM = "aes128-gcm@openssh.com";
        public static final String AES192_CBC = "aes192-cbc";
        public static final String AES192_CTR = "aes192-ctr";
        public static final String AES256_CBC = "aes256-cbc";
        public static final String AES256_CTR = "aes256-ctr";
        public static final String AES256_GCM = "aes256-gcm@openssh.com";
        public static final String ARCFOUR128 = "arcfour128";
        public static final String ARCFOUR256 = "arcfour256";
        public static final String BLOWFISH_CBC = "blowfish-cbc";
        public static final String CC20P1305_OPENSSH = "chacha20-poly1305@openssh.com";
        public static final String TRIPLE_DES_CBC = "3des-cbc";

        private Constants() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static boolean isNoneCipherIncluded(String s) {
            if (GenericUtils.isEmpty(s)) {
                return false;
            }
            Matcher m = NONE_CIPHER_PATTERN.matcher(s);
            return m.matches();
        }
    }

    public static class ParseResult
    extends NamedFactoriesListParseResult<Cipher, CipherFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<CipherFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }
    }
}

