/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.agent.unix;

import io.jenkins.cli.shaded.org.apache.sshd.agent.unix.AgentServerProxy;
import io.jenkins.cli.shaded.org.apache.sshd.client.channel.AbstractClientChannel;
import io.jenkins.cli.shaded.org.apache.sshd.common.Closeable;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.LocalWindow;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.StreamingChannel;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.tomcat.jni.Socket;
import java.io.IOException;
import java.io.OutputStream;

public class AgentForwardedChannel
extends AbstractClientChannel
implements Runnable {
    private final long socket;

    public AgentForwardedChannel(long socket, String channelType) {
        super(channelType);
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int result;
            byte[] buf = new byte[1024];
            OutputStream invIn = this.getInvertedIn();
            while ((result = Socket.recv((long)this.socket, (byte[])buf, (int)0, (int)buf.length)) != -70014) {
                if (result < 0) {
                    throw AgentServerProxy.toIOException(result);
                }
                invIn.write(buf, 0, result);
                invIn.flush();
            }
        }
        catch (Exception e) {
            this.log.warn("Processing loop exception", e);
        }
        finally {
            this.close(false);
        }
    }

    @Override
    protected synchronized void doOpen() throws IOException {
        ValidateUtils.checkTrue(!StreamingChannel.Streaming.Async.equals((Object)this.streaming), "Asynchronous streaming isn't supported yet on this channel");
        this.invertedIn = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().close(super.getInnerCloseable()).run(this.toString(), () -> Socket.close((long)this.socket)).build();
    }

    @Override
    protected synchronized void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        LocalWindow wLocal = this.getLocalWindow();
        wLocal.release(len);
        int result = Socket.send((long)this.socket, (byte[])data, (int)off, (int)((int)len));
        if (result < 0) {
            throw AgentServerProxy.toIOException(result);
        }
    }
}

