/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.future;

import io.jenkins.cli.shaded.org.apache.sshd.client.future.ConnectFuture;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.RuntimeSshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.CancelOption;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.DefaultCancellableSshFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.io.IOException;
import java.util.Objects;

public class DefaultConnectFuture
extends DefaultCancellableSshFuture<ConnectFuture>
implements ConnectFuture {
    public DefaultConnectFuture(Object id, Object lock) {
        super(id, lock);
    }

    @Override
    public ConnectFuture verify(long timeout, CancelOption ... options) throws IOException {
        CancelOption[] cancellation = options;
        if (GenericUtils.isEmpty(cancellation)) {
            cancellation = new CancelOption[]{CancelOption.CANCEL_ON_TIMEOUT, CancelOption.CANCEL_ON_INTERRUPT};
        }
        long startTime = System.nanoTime();
        ClientSession session = this.verifyResult(ClientSession.class, timeout, cancellation);
        long endTime = System.nanoTime();
        if (this.log.isDebugEnabled()) {
            IoSession ioSession = session.getIoSession();
            this.log.debug("Connected to {} after {} nanos", (Object)ioSession.getRemoteAddress(), (Object)(endTime - startTime));
        }
        return this;
    }

    @Override
    public ClientSession getSession() {
        Object v = this.getValue();
        if (v instanceof RuntimeException) {
            throw (RuntimeException)v;
        }
        if (v instanceof Error) {
            throw (Error)v;
        }
        if (v instanceof Throwable) {
            throw new RuntimeSshException("Failed to get the session.", (Throwable)v);
        }
        if (v instanceof ClientSession) {
            return (ClientSession)v;
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.getValue() instanceof ClientSession;
    }

    @Override
    public void setSession(ClientSession session) {
        Objects.requireNonNull(session, "No client session provided");
        this.setValue(session);
    }
}

