/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts;

import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.client.config.hosts.HostPatternsHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.auth.MutableUserHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.ConfigFileReaderSupport;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.PublicKeyEntry;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.MapEntryUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.OsUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.IoUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.PathUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.input.NoCloseInputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.input.NoCloseReader;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.output.NoCloseOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;

public class HostConfigEntry
extends HostPatternsHolder
implements MutableUserHolder {
    public static final String STD_CONFIG_FILENAME = "config";
    public static final String HOST_CONFIG_PROP = "Host";
    public static final String MATCH_CONFIG_PROP = "Match";
    public static final String HOST_NAME_CONFIG_PROP = "HostName";
    public static final String PORT_CONFIG_PROP = "Port";
    public static final String USER_CONFIG_PROP = "User";
    public static final String PROXY_JUMP_CONFIG_PROP = "ProxyJump";
    public static final String IDENTITY_FILE_CONFIG_PROP = "IdentityFile";
    public static final String CERTIFICATE_FILE_CONFIG_PROP = "CertificateFile";
    public static final String EXCLUSIVE_IDENTITIES_CONFIG_PROP = "IdentitiesOnly";
    public static final boolean DEFAULT_EXCLUSIVE_IDENTITIES = false;
    public static final String IDENTITY_AGENT = "IdentityAgent";
    public static final NavigableSet<String> EXPLICIT_PROPERTIES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, new String[]{"Host", "HostName", "Port", "User", "IdentityFile", "IdentitiesOnly"}));
    public static final String MULTI_VALUE_SEPARATORS = " ,";
    public static final char PATH_MACRO_CHAR = '%';
    public static final char LOCAL_HOME_MACRO = 'd';
    public static final char LOCAL_USER_MACRO = 'u';
    public static final char LOCAL_HOST_MACRO = 'l';
    public static final char REMOTE_HOST_MACRO = 'h';
    public static final char REMOTE_USER_MACRO = 'r';
    public static final char REMOTE_PORT_MACRO = 'p';
    protected String host;
    protected String hostName;
    protected int port;
    protected String username;
    protected String proxyJump;
    protected Boolean exclusiveIdentites;
    protected final Collection<String> identities = new ArrayList<String>();
    protected final Map<String, String> properties = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public HostConfigEntry() {
    }

    public HostConfigEntry(String pattern, String host, int port, String username) {
        this(pattern, host, port, username, null);
    }

    public HostConfigEntry(String pattern, String host, int port, String username, String proxyJump) {
        this.setHost(pattern);
        this.setHostName(host);
        this.setPort(port);
        this.setUsername(username);
        this.setProxyJump(proxyJump);
    }

    public void collate(HostConfigEntry that) {
        if (this.hostName == null || this.hostName.isEmpty()) {
            this.hostName = that.hostName;
        }
        if (this.port <= 0) {
            this.port = that.port;
        }
        if (this.username == null || this.username.isEmpty()) {
            this.username = that.username;
        }
        if (this.proxyJump == null || this.proxyJump.isEmpty()) {
            this.proxyJump = that.proxyJump;
        }
        if (this.exclusiveIdentites == null) {
            this.exclusiveIdentites = that.exclusiveIdentites;
        }
        this.identities.addAll(that.identities);
        for (Map.Entry<String, String> e : that.properties.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (this.properties.containsKey(key)) {
                if (!key.equalsIgnoreCase(IDENTITY_FILE_CONFIG_PROP) && !key.equalsIgnoreCase(CERTIFICATE_FILE_CONFIG_PROP)) continue;
                this.properties.put(key, this.properties.get(key) + "," + value);
                continue;
            }
            this.properties.put(key, value);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.setPatterns(HostConfigEntry.parsePatterns(HostConfigEntry.parseConfigValue(host)));
    }

    public void setHost(Collection<String> patterns) {
        this.host = GenericUtils.join(ValidateUtils.checkNotNullAndNotEmpty(patterns, "No patterns", new Object[0]), ',');
        this.setPatterns(HostConfigEntry.parsePatterns(patterns));
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
        this.setProperty(HOST_NAME_CONFIG_PROP, hostName);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        if (port <= 0) {
            this.properties.remove(PORT_CONFIG_PROP);
        } else {
            this.setProperty(PORT_CONFIG_PROP, String.valueOf(port));
        }
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
        this.setProperty(USER_CONFIG_PROP, username);
    }

    public String getProxyJump() {
        return this.proxyJump;
    }

    public void setProxyJump(String proxyJump) {
        this.proxyJump = proxyJump;
        this.setProperty(PROXY_JUMP_CONFIG_PROP, proxyJump);
    }

    public Collection<String> getIdentities() {
        return this.identities;
    }

    public void addIdentity(Path path) {
        this.addIdentity(Objects.requireNonNull(path, "No path").toAbsolutePath().normalize().toString());
    }

    public void addIdentity(String id) {
        String path = ValidateUtils.checkNotNullAndNotEmpty(id, "No identity provided");
        this.identities.add(path);
        this.appendPropertyValue(IDENTITY_FILE_CONFIG_PROP, id);
    }

    public void setIdentities(Collection<String> identities) {
        this.identities.clear();
        this.properties.remove(IDENTITY_FILE_CONFIG_PROP);
        if (identities != null) {
            identities.forEach(this::addIdentity);
        }
    }

    public boolean isIdentitiesOnly() {
        return this.exclusiveIdentites == null ? false : this.exclusiveIdentites;
    }

    public void setIdentitiesOnly(boolean identitiesOnly) {
        this.exclusiveIdentites = identitiesOnly;
        this.setProperty(EXCLUSIVE_IDENTITIES_CONFIG_PROP, Boolean.toString(identitiesOnly));
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String defaultValue) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        Map<String, String> props = this.getProperties();
        if (MapEntryUtils.isEmpty(props)) {
            return defaultValue;
        }
        String value = props.get(key);
        if (GenericUtils.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public void processProperty(String name, Collection<String> valsList) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        String joinedValue = GenericUtils.join(valsList, ',');
        if (HOST_NAME_CONFIG_PROP.equalsIgnoreCase(key)) {
            ValidateUtils.checkTrue(GenericUtils.size(valsList) == 1, "Multiple target hosts N/A: %s", (Object)joinedValue);
            this.setHostName(joinedValue);
        } else if (PORT_CONFIG_PROP.equalsIgnoreCase(key)) {
            ValidateUtils.checkTrue(GenericUtils.size(valsList) == 1, "Multiple target ports N/A: %s", (Object)joinedValue);
            int newValue = Integer.parseInt(joinedValue);
            ValidateUtils.checkTrue(newValue > 0, "Bad new port value: %d", newValue);
            this.setPort(newValue);
        } else if (USER_CONFIG_PROP.equalsIgnoreCase(key)) {
            ValidateUtils.checkTrue(GenericUtils.size(valsList) == 1, "Multiple target users N/A: %s", (Object)joinedValue);
            this.setUsername(joinedValue);
        } else if (IDENTITY_FILE_CONFIG_PROP.equalsIgnoreCase(key)) {
            ValidateUtils.checkTrue(GenericUtils.size(valsList) > 0, "No identity files specified");
            for (String id : valsList) {
                this.addIdentity(id);
            }
        } else if (EXCLUSIVE_IDENTITIES_CONFIG_PROP.equalsIgnoreCase(key)) {
            this.setIdentitiesOnly(ConfigFileReaderSupport.parseBooleanValue(ValidateUtils.checkNotNullAndNotEmpty(joinedValue, "No identities option value")));
        } else if (PROXY_JUMP_CONFIG_PROP.equalsIgnoreCase(key)) {
            this.setProxyJump(joinedValue);
        } else if (CERTIFICATE_FILE_CONFIG_PROP.equalsIgnoreCase(key)) {
            this.appendPropertyValue(key, joinedValue);
        } else {
            this.properties.put(key, joinedValue);
        }
    }

    public String appendPropertyValue(String name, String value) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        String curVal = this.getProperty(key);
        if (GenericUtils.isEmpty(value)) {
            return curVal;
        }
        if (GenericUtils.isEmpty(curVal)) {
            return this.setProperty(key, value);
        }
        return this.setProperty(key, curVal + ',' + value);
    }

    public String setProperty(String name, String value) {
        if (GenericUtils.isEmpty(value)) {
            return this.removeProperty(name);
        }
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        return this.properties.put(key, value);
    }

    public String removeProperty(String name) {
        String key = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        Map<String, String> props = this.getProperties();
        if (MapEntryUtils.isEmpty(props)) {
            return null;
        }
        return props.remove(key);
    }

    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public <A extends Appendable> A append(A sb) throws IOException {
        sb.append(HOST_CONFIG_PROP).append(' ').append(ValidateUtils.checkNotNullAndNotEmpty(this.getHost(), "No host pattern")).append(IoUtils.EOL);
        HostConfigEntry.appendNonEmptyProperty(sb, HOST_NAME_CONFIG_PROP, this.getHostName());
        HostConfigEntry.appendNonEmptyPort(sb, PORT_CONFIG_PROP, this.getPort());
        HostConfigEntry.appendNonEmptyProperty(sb, USER_CONFIG_PROP, this.getUsername());
        HostConfigEntry.appendNonEmptyValues(sb, IDENTITY_FILE_CONFIG_PROP, this.getIdentities());
        if (this.exclusiveIdentites != null) {
            HostConfigEntry.appendNonEmptyProperty(sb, EXCLUSIVE_IDENTITIES_CONFIG_PROP, ConfigFileReaderSupport.yesNoValueOf(this.exclusiveIdentites));
        }
        HostConfigEntry.appendNonEmptyProperties(sb, this.getProperties());
        return sb;
    }

    public String toString() {
        return this.getHost() + ": " + this.getUsername() + "@" + this.getHostName() + ":" + this.getPort();
    }

    public static <A extends Appendable> A appendNonEmptyPort(A sb, String name, int port) throws IOException {
        return HostConfigEntry.appendNonEmptyProperty(sb, name, port > 0 ? Integer.toString(port) : null);
    }

    public static <A extends Appendable> A appendNonEmptyProperties(A sb, Map<String, ?> props) throws IOException {
        if (MapEntryUtils.isEmpty(props)) {
            return sb;
        }
        for (Map.Entry<String, ?> pe : props.entrySet()) {
            String name = pe.getKey();
            if (EXPLICIT_PROPERTIES.contains(name)) continue;
            HostConfigEntry.appendNonEmptyProperty(sb, name, pe.getValue());
        }
        return sb;
    }

    public static <A extends Appendable> A appendNonEmptyProperty(A sb, String name, Object value) throws IOException {
        String s = Objects.toString(value, null);
        String[] vals = GenericUtils.split(s, ',');
        return HostConfigEntry.appendNonEmptyValues(sb, name, vals);
    }

    public static <A extends Appendable> A appendNonEmptyValues(A sb, String name, Object ... values) throws IOException {
        return HostConfigEntry.appendNonEmptyValues(sb, name, GenericUtils.isEmpty(values) ? Collections.emptyList() : Arrays.asList(values));
    }

    public static <A extends Appendable> A appendNonEmptyValues(A sb, String name, Collection<?> values) throws IOException {
        String k = ValidateUtils.checkNotNullAndNotEmpty(name, "No property name");
        if (GenericUtils.isEmpty(values)) {
            return sb;
        }
        for (Object v : values) {
            sb.append("    ").append(k).append(' ').append(Objects.toString(v)).append(IoUtils.EOL);
        }
        return sb;
    }

    public static List<HostConfigEntry> findMatchingEntries(String host, HostConfigEntry ... entries) {
        if (GenericUtils.isEmpty(host) || GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        return HostConfigEntry.findMatchingEntries(host, Arrays.asList(entries));
    }

    public static List<HostConfigEntry> findMatchingEntries(String host, Collection<? extends HostConfigEntry> entries) {
        if (GenericUtils.isEmpty(host) || GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        ArrayList<HostConfigEntry> matches = null;
        for (HostConfigEntry hostConfigEntry : entries) {
            if (!hostConfigEntry.isHostMatch(host, 0)) continue;
            if (matches == null) {
                matches = new ArrayList<HostConfigEntry>(entries.size());
            }
            matches.add(hostConfigEntry);
        }
        if (matches == null) {
            return Collections.emptyList();
        }
        return matches;
    }

    public static HostConfigEntryResolver toHostConfigEntryResolver(Collection<? extends HostConfigEntry> entries) {
        if (GenericUtils.isEmpty(entries)) {
            return HostConfigEntryResolver.EMPTY;
        }
        return (host, port, lclAddress, username, proxyJump, ctx) -> {
            String certificateFiles;
            Collection<String> identities;
            List<HostConfigEntry> matches = HostConfigEntry.findMatchingEntries(host, entries);
            int numMatches = GenericUtils.size(matches);
            if (numMatches <= 0) {
                return null;
            }
            HostConfigEntry entry = new HostConfigEntry(host, null, port, username);
            for (HostConfigEntry m : matches) {
                entry.collate(m);
            }
            String temp = entry.getHostName();
            if (temp == null || temp.isEmpty()) {
                entry.setHostName(host);
            }
            if ((temp = entry.getUsername()) == null || temp.isEmpty()) {
                entry.setUsername(OsUtils.getCurrentUser());
            }
            if (entry.getPort() < 1) {
                entry.setPort(22);
            }
            if (!GenericUtils.isEmpty(identities = entry.getIdentities())) {
                identities = new ArrayList<String>(identities);
                entry.setIdentities(Collections.emptyList());
                for (String id : identities) {
                    entry.addIdentity(HostConfigEntry.resolveIdentityFilePath(id, entry.getHostName(), entry.getPort(), entry.getUsername()));
                }
            }
            if (!GenericUtils.isEmpty(certificateFiles = entry.getProperty(CERTIFICATE_FILE_CONFIG_PROP))) {
                entry.removeProperty(CERTIFICATE_FILE_CONFIG_PROP);
                String[] split = certificateFiles.split(",");
                ArrayList<String> resolved = new ArrayList<String>(split.length);
                for (String raw : split) {
                    resolved.add(HostConfigEntry.resolveIdentityFilePath(raw, entry.getHostName(), entry.getPort(), entry.getUsername()));
                }
                entry.processProperty(CERTIFICATE_FILE_CONFIG_PROP, resolved);
            }
            return entry;
        };
    }

    public static List<HostConfigEntry> readHostConfigEntries(Path path, OpenOption ... options) throws IOException {
        try (InputStream input = Files.newInputStream(path, options);){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(input, true);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(URL url) throws IOException {
        try (InputStream input = url.openStream();){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(input, true);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(InputStream inStream, boolean okToClose) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(NoCloseInputStream.resolveInputStream(inStream, okToClose), StandardCharsets.UTF_8);){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(reader, true);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(Reader rdr, boolean okToClose) throws IOException {
        try (BufferedReader buf = new BufferedReader(NoCloseReader.resolveReader(rdr, okToClose));){
            List<HostConfigEntry> list = HostConfigEntry.readHostConfigEntries(buf);
            return list;
        }
    }

    public static List<HostConfigEntry> readHostConfigEntries(BufferedReader rdr) throws IOException {
        HostConfigEntry curEntry = null;
        ArrayList<HostConfigEntry> entries = new ArrayList<HostConfigEntry>();
        int lineNumber = 1;
        String line = rdr.readLine();
        while (line != null) {
            int pos;
            if (!GenericUtils.isEmpty(line = GenericUtils.replaceWhitespaceAndTrim(line)) && (pos = line.indexOf(35)) != 0) {
                ArrayList<String> valsList;
                String value;
                String key;
                if (pos > 0) {
                    line = line.substring(0, pos);
                    line = line.trim();
                }
                if ((pos = line.indexOf(61)) > 0) {
                    key = line.substring(0, pos).trim();
                    value = line.substring(pos + 1);
                    valsList = new ArrayList<String>(1);
                    valsList.add(value);
                } else {
                    pos = line.indexOf(32);
                    if (pos < 0) {
                        throw new StreamCorruptedException("No configuration value delimiter at line " + lineNumber + ": " + line);
                    }
                    key = line.substring(0, pos);
                    value = line.substring(pos + 1);
                    valsList = GenericUtils.filterToNotBlank(HostConfigEntry.parseConfigValue(value));
                }
                if (HOST_CONFIG_PROP.equalsIgnoreCase(key)) {
                    if (GenericUtils.isEmpty(valsList)) {
                        throw new StreamCorruptedException("Missing host pattern(s) at line " + lineNumber + ": " + line);
                    }
                    if (curEntry != null) {
                        entries.add(curEntry);
                    }
                    curEntry = new HostConfigEntry();
                    curEntry.setHost(valsList);
                } else {
                    if (MATCH_CONFIG_PROP.equalsIgnoreCase(key)) {
                        throw new StreamCorruptedException("Currently not able to process Match sections");
                    }
                    if (curEntry == null) {
                        curEntry = new HostConfigEntry();
                        curEntry.setHost(Collections.singletonList(ALL_HOSTS_PATTERN));
                    }
                }
                String joinedValue = GenericUtils.join(valsList, ',');
                curEntry.appendPropertyValue(key, joinedValue);
                curEntry.processProperty(key, valsList);
            }
            line = rdr.readLine();
            ++lineNumber;
        }
        if (curEntry != null) {
            entries.add(curEntry);
        }
        return entries;
    }

    public static void writeHostConfigEntries(Path path, Collection<? extends HostConfigEntry> entries, OpenOption ... options) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(path, options);){
            HostConfigEntry.writeHostConfigEntries(outputStream, true, entries);
        }
    }

    public static void writeHostConfigEntries(OutputStream outputStream, boolean okToClose, Collection<? extends HostConfigEntry> entries) throws IOException {
        if (GenericUtils.isEmpty(entries)) {
            return;
        }
        try (OutputStreamWriter w = new OutputStreamWriter(NoCloseOutputStream.resolveOutputStream(outputStream, okToClose), StandardCharsets.UTF_8);){
            HostConfigEntry.appendHostConfigEntries(w, entries);
        }
    }

    public static <A extends Appendable> A appendHostConfigEntries(A sb, Collection<? extends HostConfigEntry> entries) throws IOException {
        if (GenericUtils.isEmpty(entries)) {
            return sb;
        }
        for (HostConfigEntry hostConfigEntry : entries) {
            hostConfigEntry.append(sb);
        }
        return sb;
    }

    public static List<String> parseConfigValue(String value) {
        String s = GenericUtils.replaceWhitespaceAndTrim(value);
        if (GenericUtils.isEmpty(s)) {
            return Collections.emptyList();
        }
        for (int index = 0; index < MULTI_VALUE_SEPARATORS.length(); ++index) {
            char sep = MULTI_VALUE_SEPARATORS.charAt(index);
            int pos = s.indexOf(sep);
            if (pos < 0) continue;
            String[] vals = GenericUtils.split(s, sep);
            if (GenericUtils.isEmpty(vals)) {
                return Collections.emptyList();
            }
            return Arrays.asList(vals);
        }
        return Collections.singletonList(s);
    }

    public static String resolveIdentityFilePath(String id, String host, int port, String username) throws IOException {
        if (GenericUtils.isEmpty(id)) {
            return id;
        }
        String path = id.replace('/', File.separatorChar);
        String[] elements = GenericUtils.split(path, File.separatorChar);
        StringBuilder sb = new StringBuilder(path.length() + 64);
        for (int index = 0; index < elements.length; ++index) {
            String elem = elements[index];
            if (index > 0) {
                sb.append(File.separatorChar);
            }
            for (int curPos = 0; curPos < elem.length(); ++curPos) {
                char ch = elem.charAt(curPos);
                if (ch == '~') {
                    ValidateUtils.checkTrue(curPos == 0 && index == 0, "Home tilde must be first: %s", (Object)id);
                    PathUtils.appendUserHome(sb);
                    continue;
                }
                if (ch == '%') {
                    ValidateUtils.checkTrue(++curPos < elem.length(), "Missing macro modifier in %s", (Object)id);
                    ch = elem.charAt(curPos);
                    switch (ch) {
                        case '%': {
                            sb.append(ch);
                            break;
                        }
                        case 'd': {
                            ValidateUtils.checkTrue(curPos == 1 && index == 0, "Home macro must be first: %s", (Object)id);
                            PathUtils.appendUserHome(sb);
                            break;
                        }
                        case 'u': {
                            sb.append(ValidateUtils.checkNotNullAndNotEmpty(OsUtils.getCurrentUser(), "No local user name value"));
                            break;
                        }
                        case 'l': {
                            InetAddress address = Objects.requireNonNull(InetAddress.getLocalHost(), "No local address");
                            sb.append(ValidateUtils.checkNotNullAndNotEmpty(address.getHostName(), "No local name"));
                            break;
                        }
                        case 'h': {
                            sb.append(ValidateUtils.checkNotNullAndNotEmpty(host, "No remote host provided"));
                            break;
                        }
                        case 'r': {
                            sb.append(ValidateUtils.checkNotNullAndNotEmpty(username, "No remote user provided"));
                            break;
                        }
                        case 'p': {
                            ValidateUtils.checkTrue(port > 0, "Bad remote port value: %d", port);
                            sb.append(port);
                            break;
                        }
                        default: {
                            ValidateUtils.throwIllegalArgumentException("Bad modifier '%s' in %s", String.valueOf(ch), id);
                            break;
                        }
                    }
                    continue;
                }
                sb.append(ch);
            }
        }
        return sb.toString();
    }

    public static Path getDefaultHostConfigFile() {
        return LazyDefaultConfigFileHolder.CONFIG_FILE;
    }

    private static final class LazyDefaultConfigFileHolder {
        private static final Path CONFIG_FILE = PublicKeyEntry.getDefaultKeysFolderPath().resolve("config");

        private LazyDefaultConfigFileHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

