/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.digest.Digest;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.AbstractDH;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.MontgomeryCurve;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import java.security.KeyPair;
import java.util.Objects;

public class XDH
extends AbstractDH {
    protected MontgomeryCurve curve;
    protected byte[] f;

    public XDH(MontgomeryCurve curve) throws Exception {
        this.curve = Objects.requireNonNull(curve, "No MontgomeryCurve provided");
        this.myKeyAgree = curve.createKeyAgreement();
    }

    @Override
    protected byte[] calculateE() throws Exception {
        KeyPair keyPair = this.curve.generateKeyPair();
        this.myKeyAgree.init(keyPair.getPrivate());
        return this.curve.encode(keyPair.getPublic());
    }

    @Override
    public void setF(byte[] f) {
        this.f = Objects.requireNonNull(f, "No 'f' value provided");
    }

    @Override
    public void putE(Buffer buffer, byte[] e) {
        buffer.putBytes(e);
    }

    @Override
    public void putF(Buffer buffer, byte[] f) {
        buffer.putBytes(f);
    }

    @Override
    protected byte[] calculateK() throws Exception {
        Objects.requireNonNull(this.f, "Missing 'f' value");
        this.myKeyAgree.doPhase(this.curve.decode(this.f), true);
        return XDH.stripLeadingZeroes(this.myKeyAgree.generateSecret());
    }

    @Override
    public Digest getHash() throws Exception {
        return this.curve.createDigest();
    }
}

