/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.session.helpers;

import io.jenkins.cli.shaded.org.apache.sshd.common.SshConstants;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoWriteFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.ReservedSessionMessagesHandler;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.BufferUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.util.List;

public class ReservedSessionMessagesHandlerAdapter
extends AbstractLoggingBean
implements ReservedSessionMessagesHandler {
    public static final ReservedSessionMessagesHandlerAdapter DEFAULT = new ReservedSessionMessagesHandlerAdapter();

    @Override
    public IoWriteFuture sendIdentification(Session session, String version, List<String> extraLines) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("sendIdentification({}) version={} linesCount={}", session, version, GenericUtils.size(extraLines));
        }
        if (this.log.isTraceEnabled() && GenericUtils.isNotEmpty(extraLines)) {
            for (String line : extraLines) {
                this.log.trace("sendIdentification({}) {}", (Object)session, (Object)line);
            }
        }
        return null;
    }

    @Override
    public void handleIgnoreMessage(Session session, Buffer buffer) throws Exception {
        this.handleIgnoreMessage(session, buffer.getBytes(), buffer);
    }

    public void handleIgnoreMessage(Session session, byte[] data, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleIgnoreMessage({}) SSH_MSG_IGNORE", (Object)session);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("handleIgnoreMessage({}) data: {}", (Object)session, (Object)BufferUtils.toHex(data));
        }
    }

    @Override
    public void handleDebugMessage(Session session, Buffer buffer) throws Exception {
        this.handleDebugMessage(session, buffer.getBoolean(), buffer.getString(), buffer.getString(), buffer);
    }

    public void handleDebugMessage(Session session, boolean display, String msg, String lang, Buffer buffer) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleDebugMessage({}) SSH_MSG_DEBUG (display={}) [lang={}] '{}'", session, display, lang, msg);
        }
    }

    @Override
    public boolean handleUnimplementedMessage(Session session, int cmd, Buffer buffer) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            if (cmd == 3) {
                long seqNo = buffer.getUInt();
                this.log.debug("handleUnimplementedMessage({}) SSH_MSG_UNIMPLEMENTED - seqNo={}", (Object)session, (Object)seqNo);
            } else {
                this.log.debug("handleUnimplementedMessage({}): {}", (Object)session, (Object)SshConstants.getCommandMessageName(cmd));
            }
        }
        return false;
    }
}

