/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.channel;

import io.jenkins.cli.shaded.org.apache.sshd.common.channel.PtyMode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class SttySupport {
    public static final int DEFAULT_TERMINAL_WIDTH = 80;
    public static final int DEFAULT_TERMINAL_HEIGHT = 24;
    public static final String SSHD_STTY_COMMAND_PROP = "sshd.sttyCommand";
    public static final String DEFAULT_SSHD_STTY_COMMAND = "stty";
    private static final AtomicReference<String> STTY_COMMAND_HOLDER = new AtomicReference<String>(System.getProperty("sshd.sttyCommand", "stty"));
    private static final AtomicReference<String> TTY_PROPS_HOLDER = new AtomicReference<Object>(null);
    private static final AtomicLong TTY_PROPS_LAST_FETCHED_HOLDER = new AtomicLong(0L);

    private SttySupport() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static Map<PtyMode, Integer> getUnixPtyModes() throws IOException, InterruptedException {
        return SttySupport.parsePtyModes(SttySupport.getTtyProps());
    }

    public static Map<PtyMode, Integer> parsePtyModes(String stty) {
        EnumMap<PtyMode, Integer> modes = new EnumMap<PtyMode, Integer>(PtyMode.class);
        for (PtyMode mode : PtyMode.MODES) {
            int v;
            if (mode == PtyMode.TTY_OP_ISPEED || mode == PtyMode.TTY_OP_OSPEED) continue;
            String str = mode.name().toLowerCase();
            if (str.charAt(0) == 'v') {
                v = SttySupport.findChar(stty, str = str.substring(1));
                if (v < 0 && "reprint".equals(str)) {
                    v = SttySupport.findChar(stty, "rprnt");
                }
                if (v < 0) continue;
                modes.put(mode, v);
                continue;
            }
            v = SttySupport.findFlag(stty, str);
            if (v < 0) continue;
            modes.put(mode, v);
        }
        return modes;
    }

    private static int findFlag(String stty, String name) {
        int cur = 0;
        while (cur < stty.length()) {
            int idx1 = stty.indexOf(name, cur);
            int idx2 = idx1 + name.length();
            if (idx1 < 0) {
                return -1;
            }
            if (idx1 > 0 && Character.isLetterOrDigit(stty.charAt(idx1 - 1)) || idx2 < stty.length() && Character.isLetterOrDigit(stty.charAt(idx2))) {
                cur = idx2;
                continue;
            }
            return idx1 == 0 ? 1 : (stty.charAt(idx1 - 1) == '-' ? 0 : 1);
        }
        return -1;
    }

    private static int findChar(String stty, String name) {
        int cur = 0;
        while (cur < stty.length()) {
            int idx1 = stty.indexOf(name, cur);
            int idx2 = stty.indexOf(61, idx1);
            int idx3 = stty.indexOf(59, idx1);
            if (idx1 < 0 || idx2 < 0 || idx3 < idx2) {
                return -1;
            }
            if (idx1 > 0 && Character.isLetterOrDigit(stty.charAt(idx1 - 1)) || idx2 < stty.length() && Character.isLetterOrDigit(stty.charAt(idx2))) {
                cur = idx1 + name.length();
                continue;
            }
            String val = stty.substring(idx2 + 1, idx3 < 0 ? stty.length() : idx3).trim();
            if (val.contains("undef")) {
                return -1;
            }
            if (val.length() == 2 && val.charAt(0) == '^') {
                int v = (val.charAt(1) - 65 + 129) % 128;
                return v;
            }
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public static int getTerminalWidth() {
        try {
            int val = SttySupport.getTerminalProperty("columns");
            if (val == -1) {
                val = 80;
            }
            return val;
        }
        catch (Exception e) {
            return 80;
        }
    }

    public static int getTerminalHeight() {
        try {
            int val = SttySupport.getTerminalProperty("rows");
            if (val == -1) {
                val = 24;
            }
            return val;
        }
        catch (Exception e) {
            return 24;
        }
    }

    public static int getTerminalProperty(String prop) throws IOException, InterruptedException {
        StringTokenizer tok = new StringTokenizer(SttySupport.getTtyProps(), ";\n");
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken().trim();
            if (str.startsWith(prop)) {
                int index = str.lastIndexOf(32);
                return Integer.parseInt(str.substring(index).trim());
            }
            if (!str.endsWith(prop)) continue;
            int index = str.indexOf(32);
            return Integer.parseInt(str.substring(0, index).trim());
        }
        return -1;
    }

    public static String getTtyProps() throws IOException, InterruptedException {
        long now = System.currentTimeMillis();
        long lastFetched = TTY_PROPS_LAST_FETCHED_HOLDER.get();
        if (TTY_PROPS_HOLDER.get() == null || now - lastFetched > 1000L) {
            TTY_PROPS_HOLDER.set(SttySupport.stty("-a"));
            TTY_PROPS_LAST_FETCHED_HOLDER.set(System.currentTimeMillis());
        }
        return TTY_PROPS_HOLDER.get();
    }

    public static String stty(String args) throws IOException, InterruptedException {
        return SttySupport.exec("stty " + args + " < /dev/tty").trim();
    }

    public static String exec(String cmd) throws IOException, InterruptedException {
        return SttySupport.exec("sh", "-c", cmd);
    }

    private static String exec(String ... cmd) throws IOException, InterruptedException {
        try (ByteArrayOutputStream bout = new ByteArrayOutputStream();){
            String result;
            Process p = Runtime.getRuntime().exec(cmd);
            SttySupport.copyStream(p.getInputStream(), bout);
            SttySupport.copyStream(p.getErrorStream(), bout);
            p.waitFor();
            String string = result = new String(bout.toByteArray(), Charset.defaultCharset());
            return string;
        }
    }

    private static int copyStream(InputStream in, OutputStream bout) throws IOException {
        int count = 0;
        int c;
        while ((c = in.read()) != -1) {
            bout.write(c);
            ++count;
        }
        return count;
    }

    public static String getSttyCommand() {
        return STTY_COMMAND_HOLDER.get();
    }

    public static void setSttyCommand(String cmd) {
        STTY_COMMAND_HOLDER.set(cmd);
    }
}

