/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.auth;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.auth.UserAuthInstance;
import io.jenkins.cli.shaded.org.apache.sshd.common.auth.UserAuthMethodFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface UserAuthFactoriesManager<S extends SessionContext, M extends UserAuthInstance<S>, F extends UserAuthMethodFactory<S, M>> {
    public List<F> getUserAuthFactories();

    default public String getUserAuthFactoriesNameList() {
        return NamedResource.getNames(this.getUserAuthFactories());
    }

    default public List<String> getUserAuthFactoriesNames() {
        return NamedResource.getNameList(this.getUserAuthFactories());
    }

    public void setUserAuthFactories(List<F> var1);

    default public void setUserAuthFactoriesNameList(String names) {
        this.setUserAuthFactoriesNames(GenericUtils.split(names, ','));
    }

    default public void setUserAuthFactoriesNames(String ... names) {
        this.setUserAuthFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    public void setUserAuthFactoriesNames(Collection<String> var1);
}

