/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.io;

import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.FactoryManagerHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoService;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoServiceEventListener;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoServiceFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.AbstractCloseable;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.CloseableExecutorService;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import io.jenkins.cli.shaded.org.apache.sshd.core.CoreModuleProperties;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public abstract class AbstractIoServiceFactory
extends AbstractCloseable
implements IoServiceFactory,
FactoryManagerHolder,
ExecutorServiceCarrier {
    private IoServiceEventListener eventListener;
    private final FactoryManager manager;
    private final CloseableExecutorService executor;

    protected AbstractIoServiceFactory(FactoryManager factoryManager, CloseableExecutorService executorService) {
        this.manager = Objects.requireNonNull(factoryManager, "No factory manager provided");
        this.executor = Objects.requireNonNull(executorService, "No executor service provided");
        this.eventListener = factoryManager.getIoServiceEventListener();
    }

    @Override
    public final FactoryManager getFactoryManager() {
        return this.manager;
    }

    @Override
    public final CloseableExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public IoServiceEventListener getIoServiceEventListener() {
        return this.eventListener;
    }

    @Override
    public void setIoServiceEventListener(IoServiceEventListener listener) {
        this.eventListener = listener;
    }

    @Override
    protected void doCloseImmediately() {
        try {
            CloseableExecutorService service = this.getExecutorService();
            if (service != null && !service.isShutdown()) {
                this.log.debug("Shutdown executor");
                service.shutdownNow();
                if (service.awaitTermination(5L, TimeUnit.SECONDS)) {
                    this.log.debug("Shutdown complete");
                } else {
                    this.log.debug("Not all tasks terminated");
                }
            }
        }
        catch (Exception e) {
            this.log.debug("Exception caught while closing executor", e);
        }
        finally {
            super.doCloseImmediately();
        }
    }

    protected <S extends IoService> S autowireCreatedService(S service) {
        if (service == null) {
            return service;
        }
        service.setIoServiceEventListener(this.getIoServiceEventListener());
        return service;
    }

    public static int getNioWorkers(FactoryManager manager) {
        return CoreModuleProperties.NIO_WORKERS.getRequired(manager);
    }
}

