/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.KexExtensionParser;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.parser.DelayCompression;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.parser.Elevation;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.parser.NoFlowControl;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.parser.ServerSignatureAlgorithms;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.MapEntryUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class KexExtensions {
    public static final byte SSH_MSG_EXT_INFO = 7;
    public static final byte SSH_MSG_NEWCOMPRESS = 8;
    public static final String CLIENT_KEX_EXTENSION = "ext-info-c";
    public static final String SERVER_KEX_EXTENSION = "ext-info-s";
    public static final Predicate<String> IS_KEX_EXTENSION_SIGNAL = n -> CLIENT_KEX_EXTENSION.equalsIgnoreCase((String)n) || SERVER_KEX_EXTENSION.equalsIgnoreCase((String)n);
    private static final NavigableMap<String, KexExtensionParser<?>> EXTENSION_PARSERS = Stream.of(ServerSignatureAlgorithms.INSTANCE, NoFlowControl.INSTANCE, Elevation.INSTANCE, DelayCompression.INSTANCE).collect(Collectors.toMap(NamedResource::getName, Function.identity(), MapEntryUtils.throwingMerger(), () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));

    private KexExtensions() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet<String> getRegisteredExtensionParserNames() {
        NavigableMap<String, KexExtensionParser<?>> navigableMap = EXTENSION_PARSERS;
        synchronized (navigableMap) {
            return EXTENSION_PARSERS.isEmpty() ? Collections.emptyNavigableSet() : GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, EXTENSION_PARSERS.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KexExtensionParser<?> getRegisteredExtensionParser(String name) {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No extension name provided");
        NavigableMap<String, KexExtensionParser<?>> navigableMap = EXTENSION_PARSERS;
        synchronized (navigableMap) {
            return (KexExtensionParser)EXTENSION_PARSERS.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KexExtensionParser<?> registerExtensionParser(KexExtensionParser<?> parser) {
        Objects.requireNonNull(parser, "No parser provided");
        String name = ValidateUtils.checkNotNullAndNotEmpty(parser.getName(), "No extension name provided");
        NavigableMap<String, KexExtensionParser<?>> navigableMap = EXTENSION_PARSERS;
        synchronized (navigableMap) {
            return EXTENSION_PARSERS.put(name, parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KexExtensionParser<?> unregisterExtensionParser(String name) {
        ValidateUtils.checkNotNullAndNotEmpty(name, "No extension name provided");
        NavigableMap<String, KexExtensionParser<?>> navigableMap = EXTENSION_PARSERS;
        synchronized (navigableMap) {
            return (KexExtensionParser)EXTENSION_PARSERS.remove(name);
        }
    }

    public static List<Map.Entry<String, ?>> parseExtensions(Buffer buffer) throws IOException {
        int count = buffer.getInt();
        ValidateUtils.checkTrue(count >= 0, "Invalid extensions count: %d", count);
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList entries = new ArrayList(count);
        for (int index = 0; index < count; ++index) {
            String name = buffer.getString();
            byte[] data = buffer.getBytes();
            KexExtensionParser<?> parser = KexExtensions.getRegisteredExtensionParser(name);
            byte[] value = parser == null ? data : (byte[])parser.parseExtension(data);
            entries.add(new AbstractMap.SimpleImmutableEntry<String, byte[]>(name, value));
        }
        return entries;
    }

    public static void putExtensions(Collection<? extends Map.Entry<String, ?>> exts, Buffer buffer) throws IOException {
        int count = GenericUtils.size(exts);
        buffer.putUInt(count);
        if (count <= 0) {
            return;
        }
        for (Map.Entry<String, ?> ee : exts) {
            String name = ee.getKey();
            Object value = ee.getValue();
            KexExtensionParser<?> parser = KexExtensions.getRegisteredExtensionParser(name);
            if (parser != null) {
                parser.putExtension(value, buffer);
                continue;
            }
            buffer.putOptionalBufferedData(value);
        }
    }
}

