/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable;

import io.jenkins.cli.shaded.org.apache.sshd.common.Closeable;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.CloseFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.SshFutureListener;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.SimpleCloseable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallelCloseable
extends SimpleCloseable {
    private final Iterable<? extends Closeable> closeables;

    public ParallelCloseable(Object id, Object lock, Iterable<? extends Closeable> closeables) {
        super(id, lock);
        this.closeables = closeables == null ? Collections.emptyList() : closeables;
    }

    @Override
    protected void doClose(boolean immediately) {
        AtomicInteger count = new AtomicInteger(1);
        boolean traceEnabled = this.log.isTraceEnabled();
        SshFutureListener<CloseFuture> listener = f -> {
            int pendingCount = count.decrementAndGet();
            if (traceEnabled) {
                this.log.trace("doClose({}) completed pending: {}", (Object)immediately, (Object)pendingCount);
            }
            if (pendingCount == 0) {
                this.future.setClosed();
            }
        };
        for (Closeable closeable : this.closeables) {
            if (closeable == null) continue;
            int pendingCount = count.incrementAndGet();
            if (traceEnabled) {
                this.log.trace("doClose({}) pending closeables: {}", (Object)immediately, (Object)pendingCount);
            }
            closeable.close(immediately).addListener(listener);
        }
        listener.operationComplete(null);
    }
}

