/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.channel;

import io.jenkins.cli.shaded.org.apache.sshd.common.PropertyResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelPipedInputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelPipedOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.LocalWindow;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.output.LoggingFilterOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import io.jenkins.cli.shaded.org.apache.sshd.server.channel.ChannelDataReceiver;
import io.jenkins.cli.shaded.org.apache.sshd.server.channel.ChannelSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PipeDataReceiver
extends AbstractLoggingBean
implements ChannelDataReceiver {
    private InputStream in;
    private OutputStream out;

    public PipeDataReceiver(PropertyResolver resolver, LocalWindow localWindow) {
        ChannelPipedInputStream in = new ChannelPipedInputStream(resolver, localWindow);
        this.in = in;
        this.out = new ChannelPipedOutputStream(in);
        if (this.log.isTraceEnabled()) {
            this.out = new LoggingFilterOutputStream(this.out, "IN(" + resolver + "): ", this.log, resolver);
        }
    }

    public InputStream getIn() {
        return this.in;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public int data(ChannelSession channel, byte[] buf, int start, int len) throws IOException {
        this.out.write(buf, start, len);
        return 0;
    }
}

