/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.config;

import io.jenkins.cli.shaded.org.apache.sshd.common.Property;
import io.jenkins.cli.shaded.org.apache.sshd.common.PropertyResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.PropertyResolverUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.ConfigFileReaderSupport;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.SshConfigFileReader;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionHeartbeatController;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.MapEntryUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.server.ServerBuilder;
import io.jenkins.cli.shaded.org.apache.sshd.server.ServerFactoryManager;
import io.jenkins.cli.shaded.org.apache.sshd.server.SshServer;
import io.jenkins.cli.shaded.org.apache.sshd.server.config.AllowTcpForwardingValue;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.AgentForwardingFilter;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.ForwardingFilter;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.TcpForwardingFilter;
import io.jenkins.cli.shaded.org.apache.sshd.server.forward.X11ForwardingFilter;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Map;

public final class SshServerConfigFileReader {
    public static final Property<String> ALLOW_TCP_FORWARDING_CONFIG_PROP = Property.string("AllowTcpForwarding", "yes");
    public static final Property<String> ALLOW_AGENT_FORWARDING_CONFIG_PROP = Property.string("AllowAgentForwarding", "yes");
    public static final Property<String> ALLOW_X11_FORWARDING_CONFIG_PROP = Property.string("X11Forwarding", "no");
    public static final Property<String> BANNER_CONFIG_PROP = Property.string("Banner");
    public static final Property<String> VISUAL_HOST_KEY = Property.string("VisualHostKey", "no");
    public static final Property<Duration> SERVER_ALIVE_INTERVAL_PROP = Property.duration("ServerAliveInterval");
    public static final Property<Integer> SFTP_FORCED_VERSION_PROP = Property.integer("sftp-version");

    private SshServerConfigFileReader() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static <S extends ServerFactoryManager> S setupServerHeartbeat(S server, PropertyResolver props) {
        if (server == null || props == null) {
            return server;
        }
        Duration interval = SERVER_ALIVE_INTERVAL_PROP.getOrNull(props);
        if (interval == null || GenericUtils.isNegativeOrNull(interval)) {
            return server;
        }
        server.setSessionHeartbeat(SessionHeartbeatController.HeartbeatType.IGNORE, interval);
        return server;
    }

    public static <S extends ServerFactoryManager> S setupServerHeartbeat(S server, Map<String, ?> options) {
        if (server == null || MapEntryUtils.isEmpty(options)) {
            return server;
        }
        return SshServerConfigFileReader.setupServerHeartbeat(server, PropertyResolverUtils.toPropertyResolver(options));
    }

    public static <S extends ServerFactoryManager> S setupSftpSubsystem(S server, PropertyResolver props) {
        if (server == null || props == null) {
            return server;
        }
        Integer version = SFTP_FORCED_VERSION_PROP.getOrNull(props);
        if (version != null && version >= 0) {
            SFTP_FORCED_VERSION_PROP.set(server, version);
        }
        return server;
    }

    public static <S extends SshServer> S configure(S server, PropertyResolver props, boolean lenient, boolean ignoreUnsupported) {
        SshConfigFileReader.configure(server, props, lenient, ignoreUnsupported);
        SshConfigFileReader.configureKeyExchanges(server, props, lenient, ServerBuilder.DH2KEX, ignoreUnsupported);
        SshServerConfigFileReader.setupServerHeartbeat(server, props);
        return server;
    }

    public static ForwardingFilter resolveServerForwarding(PropertyResolver options) {
        if (PropertyResolver.isEmpty(options)) {
            return AcceptAllForwardingFilter.INSTANCE;
        }
        AgentForwardingFilter agentFilter = SshServerConfigFileReader.resolveAgentForwardingFilter(options);
        TcpForwardingFilter tcpFilter = SshServerConfigFileReader.resolveTcpForwardingFilter(options);
        X11ForwardingFilter x11Filter = SshServerConfigFileReader.resolveX11ForwardingFilter(options);
        return ForwardingFilter.asForwardingFilter(agentFilter, x11Filter, tcpFilter);
    }

    public static AgentForwardingFilter resolveAgentForwardingFilter(PropertyResolver options) {
        String value = ALLOW_AGENT_FORWARDING_CONFIG_PROP.getRequired(options);
        return AgentForwardingFilter.of(ConfigFileReaderSupport.parseBooleanValue(value));
    }

    public static TcpForwardingFilter resolveTcpForwardingFilter(PropertyResolver options) {
        String value = ALLOW_TCP_FORWARDING_CONFIG_PROP.getRequired(options);
        AllowTcpForwardingValue filter = AllowTcpForwardingValue.fromString(value);
        ValidateUtils.checkNotNull(filter, "Unknown %s value: %s", ALLOW_TCP_FORWARDING_CONFIG_PROP, value);
        return filter;
    }

    public static X11ForwardingFilter resolveX11ForwardingFilter(PropertyResolver options) {
        String value = ALLOW_X11_FORWARDING_CONFIG_PROP.getRequired(options);
        return X11ForwardingFilter.of(ConfigFileReaderSupport.parseBooleanValue(value));
    }

    public static Object resolveBanner(PropertyResolver options) {
        String bannerOption = BANNER_CONFIG_PROP.getOrNull(options);
        if (GenericUtils.isEmpty(bannerOption)) {
            bannerOption = VISUAL_HOST_KEY.getRequired(options);
            bannerOption = ConfigFileReaderSupport.parseBooleanValue(bannerOption) ? "#auto-welcome-banner" : null;
        }
        if (GenericUtils.isEmpty(bannerOption)) {
            return "Welcome to SSHD\n";
        }
        if (PropertyResolverUtils.isNoneValue(bannerOption)) {
            return null;
        }
        if ("#auto-welcome-banner".equalsIgnoreCase(bannerOption)) {
            return bannerOption;
        }
        if (bannerOption != null) {
            return Paths.get(bannerOption, new String[0]);
        }
        return null;
    }
}

