/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.channel;

import io.jenkins.cli.shaded.org.apache.sshd.common.SshConstants;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Channel;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.ChannelHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.IoWriteFutureImpl;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.Window;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.throttle.ChannelStreamWriter;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.CloseFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.IoWriteFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.io.WritePendingException;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.AbstractCloseable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;

public class ChannelAsyncOutputStream
extends AbstractCloseable
implements IoOutputStream,
ChannelHolder {
    protected final WriteState writeState = new WriteState();
    private final Channel channelInstance;
    private final ChannelStreamWriter packetWriter;
    private final byte cmd;
    private final Object packetWriteId;
    private boolean sendChunkIfRemoteWindowIsSmallerThanPacketSize;

    public ChannelAsyncOutputStream(Channel channel, byte cmd) {
        this(channel, cmd, false);
    }

    public ChannelAsyncOutputStream(Channel channel, byte cmd, boolean sendChunkIfRemoteWindowIsSmallerThanPacketSize) {
        this.channelInstance = Objects.requireNonNull(channel, "No channel");
        this.sendChunkIfRemoteWindowIsSmallerThanPacketSize = sendChunkIfRemoteWindowIsSmallerThanPacketSize;
        this.packetWriter = this.channelInstance.resolveChannelStreamWriter(channel, cmd);
        this.cmd = cmd;
        this.packetWriteId = channel.toString() + "[" + SshConstants.getCommandMessageName(cmd) + "]";
    }

    @Override
    public Channel getChannel() {
        return this.channelInstance;
    }

    public byte getCommandType() {
        return this.cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IoWriteFuture writeBuffer(Buffer buffer) throws IOException {
        if (this.isClosing()) {
            throw new EOFException("Closing: " + this.writeState);
        }
        IoWriteFutureImpl future = new IoWriteFutureImpl(this.packetWriteId, buffer);
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            if (!AbstractCloseable.State.Opened.equals((Object)this.writeState.openState)) {
                throw new EOFException("Closing: " + this.writeState);
            }
            if (this.writeState.writeInProgress) {
                throw new WritePendingException("A write operation is already pending");
            }
            this.writeState.lastWrite = future;
            this.writeState.pendingWrite = future;
            this.writeState.writeInProgress = true;
            this.writeState.waitingOnIo = false;
        }
        this.doWriteIfPossible(false);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void preClose() {
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            this.writeState.openState = (AbstractCloseable.State)((Object)this.state.get());
        }
        super.preClose();
    }

    @Override
    protected void doCloseImmediately() {
        try {
            if (!(this.packetWriter instanceof Channel)) {
                try {
                    this.packetWriter.close();
                }
                catch (IOException e) {
                    this.error("preClose({}) Failed ({}) to pre-close packet writer: {}", this, e.getClass().getSimpleName(), e.getMessage(), e);
                }
            }
            super.doCloseImmediately();
        }
        finally {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        IoWriteFutureImpl current = null;
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            this.writeState.openState = AbstractCloseable.State.Closed;
            current = this.writeState.pendingWrite;
            this.writeState.pendingWrite = null;
            this.writeState.waitingOnIo = false;
        }
        if (current != null) {
            this.terminateFuture(current);
        }
    }

    protected void terminateFuture(IoWriteFutureImpl future) {
        if (!future.isDone()) {
            if (future.getBuffer().available() > 0) {
                future.setValue(new EOFException("Channel closing"));
            } else {
                future.setValue(Boolean.TRUE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseFuture doCloseGracefully() {
        IoWriteFutureImpl last;
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            last = this.writeState.lastWrite;
        }
        if (last == null) {
            return this.builder().build().close(false);
        }
        return this.builder().when(last).build().close(false);
    }

    public void onWindowExpanded() throws IOException {
        this.doWriteIfPossible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doWriteIfPossible(boolean resume) {
        AbstractCloseable.State openState;
        IoWriteFutureImpl currentWrite = null;
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            this.writeState.windowExpanded = resume;
            openState = this.writeState.openState;
            if (this.writeState.pendingWrite == null || resume && this.writeState.waitingOnIo) {
                return;
            }
            currentWrite = this.writeState.pendingWrite;
            this.writeState.pendingWrite = null;
            this.writeState.windowExpanded = false;
            this.writeState.waitingOnIo = false;
        }
        while (currentWrite != null) {
            if (AbstractCloseable.State.Immediate.equals((Object)openState) || AbstractCloseable.State.Closed.equals((Object)openState)) {
                this.terminateFuture(currentWrite);
                break;
            }
            IoWriteFutureImpl nextWrite = this.writePacket(currentWrite, resume);
            if (nextWrite == null) break;
            WriteState writeState2 = this.writeState;
            synchronized (writeState2) {
                this.writeState.waitingOnIo = false;
                openState = this.writeState.openState;
                if (this.writeState.windowExpanded) {
                    this.writeState.windowExpanded = false;
                    currentWrite = nextWrite;
                } else {
                    if (AbstractCloseable.State.Opened.equals((Object)openState)) {
                        this.writeState.pendingWrite = nextWrite;
                    } else {
                        this.writeState.writeInProgress = false;
                    }
                    currentWrite = null;
                }
            }
            if (currentWrite != null || AbstractCloseable.State.Opened.equals((Object)openState)) continue;
            this.terminateFuture(nextWrite);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IoWriteFutureImpl writePacket(IoWriteFutureImpl future, boolean resume) {
        block22: {
            IoWriteFuture writeFuture;
            long length;
            Window remoteWindow;
            Channel channel;
            int total;
            Buffer buffer;
            block21: {
                long packetSize;
                block23: {
                    buffer = future.getBuffer();
                    total = buffer.available();
                    if (total <= 0) break block22;
                    channel = this.getChannel();
                    remoteWindow = channel.getRemoteWindow();
                    long remoteWindowSize = remoteWindow.getSize();
                    packetSize = remoteWindow.getPacketSize();
                    if ((long)total <= remoteWindowSize) break block23;
                    if (remoteWindowSize >= packetSize) {
                        length = packetSize;
                        break block21;
                    } else if (this.isSendChunkIfRemoteWindowIsSmallerThanPacketSize()) {
                        length = remoteWindowSize;
                        break block21;
                    } else {
                        if (future instanceof BufferedFuture) {
                            return future;
                        }
                        BufferedFuture f2 = new BufferedFuture(future.getId(), new ByteArrayBuffer(buffer.getCompactData()));
                        f2.addListener(w -> future.setValue(w.getException() != null ? w.getException() : Boolean.valueOf(w.isWritten())));
                        if (!this.log.isTraceEnabled()) return f2;
                        this.log.trace("doWriteIfPossible({})[resume={}] waiting for window space {}", this, resume, remoteWindowSize);
                        return f2;
                    }
                }
                if ((long)total > packetSize) {
                    if (buffer.rpos() > 0 && !(future instanceof BufferedFuture)) {
                        BufferedFuture f3 = new BufferedFuture(future.getId(), new ByteArrayBuffer(buffer.getCompactData()));
                        f3.addListener(w -> future.setValue(w.getException() != null ? w.getException() : Boolean.valueOf(w.isWritten())));
                        long length2 = packetSize;
                        if (!this.log.isTraceEnabled()) return this.writePacket(f3, resume);
                        this.log.trace("doWriteIfPossible({})[resume={}] attempting to write {} out of {}", this, resume, length2, total);
                        return this.writePacket(f3, resume);
                    }
                    length = packetSize;
                } else {
                    length = total;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("doWriteIfPossible({})[resume={}] attempting to write {} bytes", this, resume, length);
                    }
                }
            }
            if (length <= 0L) {
                if (resume) return future;
                if (!this.log.isDebugEnabled()) return future;
                this.log.debug("doWriteIfPossible({}) delaying write until space is available in the remote window", (Object)this);
                return future;
            }
            if (resume && this.log.isDebugEnabled()) {
                this.log.debug("Resuming {} write due to more space ({}) available in the remote window", (Object)this, (Object)length);
            }
            if (length >= 0x7FFFFFF3L) {
                throw new IllegalArgumentException("Command " + SshConstants.getCommandMessageName(this.cmd) + " length (" + length + ") exceeds int boundaries");
            }
            Buffer buf = this.createSendBuffer(buffer, channel, length);
            remoteWindow.consume(length);
            try {
                writeFuture = this.packetWriter.writeData(buf);
            }
            catch (IOException e) {
                WriteState writeState = this.writeState;
                synchronized (writeState) {
                    this.writeState.writeInProgress = false;
                }
                future.setValue(e);
                return null;
            }
            WriteState writeState = this.writeState;
            synchronized (writeState) {
                this.writeState.pendingWrite = future;
                this.writeState.waitingOnIo = true;
            }
            writeFuture.addListener(f -> this.onWritten(future, total, length, (IoWriteFuture)f));
            return null;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("doWriteIfPossible({}) current buffer sent", (Object)this);
        }
        WriteState writeState = this.writeState;
        synchronized (writeState) {
            this.writeState.writeInProgress = false;
        }
        future.setValue(Boolean.TRUE);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onWritten(IoWriteFutureImpl future, int total, long length, IoWriteFuture f) {
        if (f.isWritten()) {
            if ((long)total > length) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("onWritten({}) completed write of {} out of {}", this, length, total);
                }
                this.doWriteIfPossible(false);
            } else {
                WriteState writeState = this.writeState;
                synchronized (writeState) {
                    IoWriteFutureImpl storedFuture = this.writeState.pendingWrite;
                    if (storedFuture == future) {
                        this.writeState.pendingWrite = null;
                        this.writeState.writeInProgress = false;
                        this.writeState.waitingOnIo = false;
                    } else if (storedFuture == null) {
                        this.writeState.writeInProgress = false;
                        this.writeState.waitingOnIo = false;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("onWritten({}) future already reset to null after successful write (stream closed)", (Object)this);
                        }
                    } else {
                        this.log.error("onWritten({}) future changed during write", (Object)this);
                    }
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace("onWritten({}) completed write len={}", (Object)this, (Object)total);
                }
                future.setValue(Boolean.TRUE);
            }
        } else {
            Throwable reason = f.getException();
            this.debug("onWritten({}) failed ({}) to complete write of {} out of {}: {}", this, reason.getClass().getSimpleName(), length, total, reason.getMessage(), reason);
            WriteState writeState = this.writeState;
            synchronized (writeState) {
                IoWriteFutureImpl storedFuture = this.writeState.pendingWrite;
                if (storedFuture == future) {
                    this.writeState.pendingWrite = null;
                    this.writeState.writeInProgress = false;
                    this.writeState.waitingOnIo = false;
                } else if (storedFuture == null) {
                    this.writeState.writeInProgress = false;
                    this.writeState.waitingOnIo = false;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("onWritten({}) future already reset to null after exception (stream closed): {}", (Object)this, (Object)reason.toString());
                    }
                } else {
                    this.log.error("onWritten({}) future changed during failed write; exception {}", (Object)this, (Object)reason.toString());
                }
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("onWritten({}) failed write len={}", (Object)this, (Object)total);
            }
            future.setValue(reason);
        }
    }

    protected Buffer createSendBuffer(Buffer buffer, Channel channel, long length) {
        SessionContext.validateSessionPayloadSize(length, "Invalid send buffer length: %d");
        Object s = channel.getSession();
        Buffer buf = s.createBuffer(this.cmd, (int)length + 12);
        buf.putUInt(channel.getRecipient());
        if (this.cmd == 95) {
            buf.putUInt(1L);
        }
        buf.putUInt(length);
        buf.putRawBytes(buffer.array(), buffer.rpos(), (int)length);
        buffer.rpos(buffer.rpos() + (int)length);
        return buf;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getChannel() + "] cmd=" + SshConstants.getCommandMessageName(this.cmd & 0xFF);
    }

    public boolean isSendChunkIfRemoteWindowIsSmallerThanPacketSize() {
        return this.sendChunkIfRemoteWindowIsSmallerThanPacketSize;
    }

    public void setSendChunkIfRemoteWindowIsSmallerThanPacketSize(boolean sendChunkIfRemoteWindowIsSmallerThanPacketSize) {
        this.sendChunkIfRemoteWindowIsSmallerThanPacketSize = sendChunkIfRemoteWindowIsSmallerThanPacketSize;
    }

    protected static class WriteState {
        protected IoWriteFutureImpl lastWrite;
        protected IoWriteFutureImpl pendingWrite;
        protected boolean writeInProgress;
        protected boolean windowExpanded;
        protected boolean waitingOnIo;
        protected AbstractCloseable.State openState = AbstractCloseable.State.Opened;

        protected WriteState() {
        }
    }

    protected static class BufferedFuture
    extends IoWriteFutureImpl {
        BufferedFuture(Object id, Buffer buffer) {
            super(id, buffer);
        }
    }
}

