/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.openssh;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.Objects;

public class OpenSSHDSSPrivateKeyEntryDecoder
extends AbstractPrivateKeyEntryDecoder<DSAPublicKey, DSAPrivateKey> {
    public static final OpenSSHDSSPrivateKeyEntryDecoder INSTANCE = new OpenSSHDSSPrivateKeyEntryDecoder();

    public OpenSSHDSSPrivateKeyEntryDecoder() {
        super(DSAPublicKey.class, DSAPrivateKey.class, Collections.unmodifiableList(Collections.singletonList("ssh-dss")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DSAPrivateKey decodePrivateKey(SessionContext session, String keyType, FilePasswordProvider passwordProvider, InputStream keyData) throws IOException, GeneralSecurityException {
        if (!"ssh-dss".equals(keyType)) {
            throw new InvalidKeySpecException("Unexpected key type: " + keyType);
        }
        BigInteger p = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger q = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger g = KeyEntryResolver.decodeBigInt(keyData);
        BigInteger y = KeyEntryResolver.decodeBigInt(keyData);
        Objects.requireNonNull(y, "No public key data");
        BigInteger x = KeyEntryResolver.decodeBigInt(keyData);
        try {
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)this.generatePrivateKey(new DSAPrivateKeySpec(x, p, q, g));
            return dSAPrivateKey;
        }
        finally {
            p = null;
            q = null;
            g = null;
            y = null;
            x = null;
        }
    }

    @Override
    public String encodePrivateKey(SecureByteArrayOutputStream s, DSAPrivateKey key, DSAPublicKey pubKey) throws IOException {
        Objects.requireNonNull(key, "No private key provided");
        DSAParams keyParams = Objects.requireNonNull(key.getParams(), "No DSA params available");
        BigInteger p = keyParams.getP();
        KeyEntryResolver.encodeBigInt(s, p);
        KeyEntryResolver.encodeBigInt(s, keyParams.getQ());
        BigInteger g = keyParams.getG();
        KeyEntryResolver.encodeBigInt(s, g);
        BigInteger x = key.getX();
        BigInteger y = pubKey != null ? pubKey.getY() : g.modPow(x, p);
        KeyEntryResolver.encodeBigInt(s, y);
        KeyEntryResolver.encodeBigInt(s, x);
        return "ssh-dss";
    }

    @Override
    public boolean isPublicKeyRecoverySupported() {
        return true;
    }

    @Override
    public DSAPublicKey recoverPublicKey(DSAPrivateKey privateKey) throws GeneralSecurityException {
        return KeyUtils.recoverDSAPublicKey(privateKey);
    }

    @Override
    public DSAPublicKey clonePublicKey(DSAPublicKey key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        DSAParams params = key.getParams();
        if (params == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (DSAPublicKey)this.generatePublicKey(new DSAPublicKeySpec(key.getY(), params.getP(), params.getQ(), params.getG()));
    }

    @Override
    public DSAPrivateKey clonePrivateKey(DSAPrivateKey key) throws GeneralSecurityException {
        if (key == null) {
            return null;
        }
        DSAParams params = key.getParams();
        if (params == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (DSAPrivateKey)this.generatePrivateKey(new DSAPrivateKeySpec(key.getX(), params.getP(), params.getQ(), params.getG()));
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        return SecurityUtils.getKeyPairGenerator("DSA");
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        return SecurityUtils.getKeyFactory("DSA");
    }
}

