/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.channel;

import io.jenkins.cli.shaded.org.apache.sshd.client.channel.PtyCapableChannelSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.Session;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.core.CoreModuleProperties;
import java.io.IOException;
import java.util.Date;
import java.util.Map;

public class ChannelExec
extends PtyCapableChannelSession {
    private final String command;

    public ChannelExec(String command, PtyChannelConfigurationHolder configHolder, Map<String, ?> env) {
        super(false, configHolder, env);
        this.command = ValidateUtils.checkNotNullAndNotEmpty(command, "Command may not be null/empty");
    }

    @Override
    protected void doOpen() throws IOException {
        this.doOpenPty();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doOpen({}) send SSH_MSG_CHANNEL_REQUEST exec command={}", (Object)this, (Object)this.command);
        }
        Session session = this.getSession();
        boolean wantReply = CoreModuleProperties.REQUEST_EXEC_REPLY.getRequired(this);
        Buffer buffer = session.createBuffer((byte)98, this.command.length() + 32);
        buffer.putUInt(this.getRecipient());
        buffer.putString("exec");
        buffer.putBoolean(wantReply);
        buffer.putString(this.command);
        this.addPendingRequest("exec", wantReply);
        this.writePacket(buffer);
        super.doOpen();
    }

    @Override
    public void handleSuccess() throws IOException {
        Date pending = this.removePendingRequest("exec");
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleSuccess({}) pending={}, command={}", this, pending, this.command);
        }
    }

    @Override
    public void handleFailure() throws IOException {
        Date pending = this.removePendingRequest("exec");
        if (pending != null) {
            this.log.warn("handleFailure({}) pending since={}, command={}", this, pending, this.command);
            this.close(true);
        }
    }
}

