/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.kex;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.BuiltinCiphers;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.Cipher;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.BuiltinCompressions;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.Compression;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.KeyExchangeFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.kex.extension.KexExtensionHandlerManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.mac.BuiltinMacs;
import io.jenkins.cli.shaded.org.apache.sshd.common.mac.Mac;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.SignatureFactoriesManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface KexFactoryManager
extends SignatureFactoriesManager,
KexExtensionHandlerManager {
    public List<KeyExchangeFactory> getKeyExchangeFactories();

    public void setKeyExchangeFactories(List<KeyExchangeFactory> var1);

    public List<NamedFactory<Cipher>> getCipherFactories();

    default public String getCipherFactoriesNameList() {
        return NamedResource.getNames(this.getCipherFactories());
    }

    default public List<String> getCipherFactoriesNames() {
        return NamedResource.getNameList(this.getCipherFactories());
    }

    public void setCipherFactories(List<NamedFactory<Cipher>> var1);

    default public void setCipherFactoriesNameList(String names) {
        this.setCipherFactoriesNames(GenericUtils.split(names, ','));
    }

    default public void setCipherFactoriesNames(String ... names) {
        this.setCipherFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setCipherFactoriesNames(Collection<String> names) {
        BuiltinCiphers.ParseResult result = BuiltinCiphers.parseCiphersList(names);
        List<NamedFactory<Cipher>> factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported cipher factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported cipher factories found: %s", unsupported);
        this.setCipherFactories(factories);
    }

    public List<NamedFactory<Compression>> getCompressionFactories();

    default public String getCompressionFactoriesNameList() {
        return NamedResource.getNames(this.getCompressionFactories());
    }

    default public List<String> getCompressionFactoriesNames() {
        return NamedResource.getNameList(this.getCompressionFactories());
    }

    public void setCompressionFactories(List<NamedFactory<Compression>> var1);

    default public void setCompressionFactoriesNameList(String names) {
        this.setCompressionFactoriesNames(GenericUtils.split(names, ','));
    }

    default public void setCompressionFactoriesNames(String ... names) {
        this.setCompressionFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setCompressionFactoriesNames(Collection<String> names) {
        BuiltinCompressions.ParseResult result = BuiltinCompressions.parseCompressionsList(names);
        List<NamedFactory<Compression>> factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported compression factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported compression factories found: %s", unsupported);
        this.setCompressionFactories(factories);
    }

    public List<NamedFactory<Mac>> getMacFactories();

    default public String getMacFactoriesNameList() {
        return NamedResource.getNames(this.getMacFactories());
    }

    default public List<String> getMacFactoriesNames() {
        return NamedResource.getNameList(this.getMacFactories());
    }

    public void setMacFactories(List<NamedFactory<Mac>> var1);

    default public void setMacFactoriesNameList(String names) {
        this.setMacFactoriesNames(GenericUtils.split(names, ','));
    }

    default public void setMacFactoriesNames(String ... names) {
        this.setMacFactoriesNames(GenericUtils.isEmpty((Object[])names) ? Collections.emptyList() : Arrays.asList(names));
    }

    default public void setMacFactoriesNames(Collection<String> names) {
        BuiltinMacs.ParseResult result = BuiltinMacs.parseMacsList(names);
        List<NamedFactory<Mac>> factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported MAC factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported MAC factories found: %s", unsupported);
        this.setMacFactories(factories);
    }
}

