/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.openssh;

import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.ECCurves;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.impl.AbstractPrivateKeyEntryDecoder;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.output.SecureByteArrayOutputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;

public class OpenSSHECDSAPrivateKeyEntryDecoder
extends AbstractPrivateKeyEntryDecoder<ECPublicKey, ECPrivateKey> {
    public static final OpenSSHECDSAPrivateKeyEntryDecoder INSTANCE = new OpenSSHECDSAPrivateKeyEntryDecoder();

    public OpenSSHECDSAPrivateKeyEntryDecoder() {
        super(ECPublicKey.class, ECPrivateKey.class, ECCurves.KEY_TYPES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ECPrivateKey decodePrivateKey(SessionContext session, String keyType, FilePasswordProvider passwordProvider, InputStream keyData) throws IOException, GeneralSecurityException {
        String encCurveName;
        ECCurves curve = ECCurves.fromKeyType(keyType);
        if (curve == null) {
            throw new InvalidKeySpecException("Not an EC curve name: " + keyType);
        }
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        String keyCurveName = curve.getName();
        if (!keyCurveName.equals(encCurveName = KeyEntryResolver.decodeString(keyData, 1024))) {
            throw new InvalidKeySpecException("Mismatched key curve name (" + keyCurveName + ") vs. encoded one (" + encCurveName + ")");
        }
        byte[] pubKey = KeyEntryResolver.readRLEBytes(keyData, Short.MAX_VALUE);
        Objects.requireNonNull(pubKey, "No public point");
        BigInteger s = KeyEntryResolver.decodeBigInt(keyData);
        ECParameterSpec params = curve.getParameters();
        try {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)this.generatePrivateKey(new ECPrivateKeySpec(s, params));
            return eCPrivateKey;
        }
        finally {
            s = null;
        }
    }

    @Override
    public String encodePrivateKey(SecureByteArrayOutputStream s, ECPrivateKey key, ECPublicKey pubKey) throws IOException {
        Objects.requireNonNull(key, "No private key provided");
        Objects.requireNonNull(pubKey, "No public key provided");
        ECCurves curve = ECCurves.fromECKey(key);
        if (curve == null) {
            return null;
        }
        String curveName = curve.getName();
        KeyEntryResolver.encodeString(s, curveName);
        ECCurves.ECPointCompression.UNCOMPRESSED.writeECPoint(s, curveName, pubKey.getW());
        KeyEntryResolver.encodeBigInt(s, key.getS());
        return curve.getKeyType();
    }

    @Override
    public ECPublicKey recoverPublicKey(ECPrivateKey prvKey) throws GeneralSecurityException {
        ECCurves curve = ECCurves.fromECKey(prvKey);
        if (curve == null) {
            throw new InvalidKeyException("Unknown curve");
        }
        return (ECPublicKey)super.recoverPublicKey(prvKey);
    }

    @Override
    public ECPublicKey clonePublicKey(ECPublicKey key) throws GeneralSecurityException {
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        if (key == null) {
            return null;
        }
        ECParameterSpec params = key.getParams();
        if (params == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (ECPublicKey)this.generatePublicKey(new ECPublicKeySpec(key.getW(), params));
    }

    @Override
    public ECPrivateKey clonePrivateKey(ECPrivateKey key) throws GeneralSecurityException {
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        if (key == null) {
            return null;
        }
        ECParameterSpec params = key.getParams();
        if (params == null) {
            throw new InvalidKeyException("Missing parameters in key");
        }
        return (ECPrivateKey)this.generatePrivateKey(new ECPrivateKeySpec(key.getS(), params));
    }

    @Override
    public KeyFactory getKeyFactoryInstance() throws GeneralSecurityException {
        if (SecurityUtils.isECCSupported()) {
            return SecurityUtils.getKeyFactory("EC");
        }
        throw new NoSuchProviderException("ECC not supported");
    }

    @Override
    public KeyPair generateKeyPair(int keySize) throws GeneralSecurityException {
        ECCurves curve = ECCurves.fromCurveSize(keySize);
        if (curve == null) {
            throw new InvalidKeySpecException("Unknown curve for key size=" + keySize);
        }
        KeyPairGenerator gen = this.getKeyPairGenerator();
        gen.initialize(curve.getParameters());
        return gen.generateKeyPair();
    }

    @Override
    public KeyPairGenerator getKeyPairGenerator() throws GeneralSecurityException {
        if (SecurityUtils.isECCSupported()) {
            return SecurityUtils.getKeyPairGenerator("EC");
        }
        throw new NoSuchProviderException("ECC not supported");
    }
}

