/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable;

import io.jenkins.cli.shaded.org.apache.sshd.common.SshException;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.DefaultSshFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.SshFuture;
import io.jenkins.cli.shaded.org.apache.sshd.common.future.SshFutureListener;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable.SimpleCloseable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;

public class FuturesCloseable<T extends SshFuture>
extends SimpleCloseable {
    private final Iterable<? extends SshFuture<T>> futures;

    public FuturesCloseable(Object id, Object lock, Iterable<? extends SshFuture<T>> futures) {
        super(id, lock);
        this.futures = futures == null ? Collections.emptyList() : futures;
    }

    @Override
    protected void doClose(boolean immediately) {
        if (immediately) {
            for (SshFuture<T> f2 : this.futures) {
                if (!(f2 instanceof DefaultSshFuture)) continue;
                ((DefaultSshFuture)f2).setValue(new SshException("Closed"));
            }
            this.future.setClosed();
        } else {
            AtomicInteger count = new AtomicInteger(1);
            boolean traceEnabled = this.log.isTraceEnabled();
            SshFutureListener<SshFuture> listener = f -> {
                int pendingCount = count.decrementAndGet();
                if (traceEnabled) {
                    this.log.trace("doClose(" + immediately + ") complete pending: " + pendingCount);
                }
                if (pendingCount == 0) {
                    this.future.setClosed();
                }
            };
            for (SshFuture<SshFuture> sshFuture : this.futures) {
                if (sshFuture == null) continue;
                int pendingCount = count.incrementAndGet();
                if (traceEnabled) {
                    this.log.trace("doClose(" + immediately + ") future pending: " + pendingCount);
                }
                sshFuture.addListener(listener);
            }
            listener.operationComplete(null);
        }
    }
}

