/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.compression;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.Compression;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.CompressionDelayedZlib;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.CompressionFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.CompressionNone;
import io.jenkins.cli.shaded.org.apache.sshd.common.compression.CompressionZlib;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.NamedFactoriesListParseResult;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

public enum BuiltinCompressions implements CompressionFactory
{
    none("none"){

        @Override
        public Compression create() {
            return new CompressionNone();
        }

        @Override
        public boolean isCompressionExecuted() {
            return false;
        }
    }
    ,
    zlib("zlib"){

        @Override
        public Compression create() {
            return new CompressionZlib();
        }
    }
    ,
    delayedZlib("zlib@openssh.com"){

        @Override
        public Compression create() {
            return new CompressionDelayedZlib();
        }

        @Override
        public boolean isDelayed() {
            return true;
        }
    };

    public static final Set<BuiltinCompressions> VALUES;
    private static final Map<String, CompressionFactory> EXTENSIONS;
    private final String name;

    private BuiltinCompressions(String n2) {
        this.name = n2;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isDelayed() {
        return false;
    }

    @Override
    public boolean isCompressionExecuted() {
        return true;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public final boolean isSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(CompressionFactory extension) {
        String name = Objects.requireNonNull(extension, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinCompressions.fromFactoryName(name) == null, "Extension overrides built-in: %s", (Object)name);
        Map<String, CompressionFactory> map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(name), "Extension overrides existing: %s", (Object)name);
            EXTENSIONS.put(name, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet<CompressionFactory> getRegisteredExtensions() {
        Map<String, CompressionFactory> map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressionFactory unregisterExtension(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        Map<String, CompressionFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.remove(name);
        }
    }

    public static BuiltinCompressions fromFactoryName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static ParseResult parseCompressionsList(String compressions) {
        return BuiltinCompressions.parseCompressionsList(GenericUtils.split(compressions, ','));
    }

    public static ParseResult parseCompressionsList(String ... compressions) {
        return BuiltinCompressions.parseCompressionsList(GenericUtils.isEmpty((Object[])compressions) ? Collections.emptyList() : Arrays.asList(compressions));
    }

    public static ParseResult parseCompressionsList(Collection<String> compressions) {
        if (GenericUtils.isEmpty(compressions)) {
            return ParseResult.EMPTY;
        }
        ArrayList<CompressionFactory> factories = new ArrayList<CompressionFactory>(compressions.size());
        List<String> unknown = Collections.emptyList();
        for (String name : compressions) {
            CompressionFactory c = BuiltinCompressions.resolveFactory(name);
            if (c != null) {
                factories.add(c);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult((List<CompressionFactory>)factories, unknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompressionFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        BuiltinCompressions c = BuiltinCompressions.fromFactoryName(name);
        if (c != null) {
            return c;
        }
        Map<String, CompressionFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.get(name);
        }
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinCompressions.class));
        EXTENSIONS = new TreeMap<String, CompressionFactory>(String.CASE_INSENSITIVE_ORDER);
    }

    public static final class Constants {
        public static final String NONE = "none";
        public static final String ZLIB = "zlib";
        public static final String DELAYED_ZLIB = "zlib@openssh.com";

        private Constants() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }

    public static class ParseResult
    extends NamedFactoriesListParseResult<Compression, CompressionFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<CompressionFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }
    }
}

