/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import com.trilead.ssh2.crypto.PEMDecoder;
import com.trilead.ssh2.signature.DSAPrivateKey;
import com.trilead.ssh2.signature.RSAPrivateKey;
import java.io.Console;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrivateKeyProvider {
    private List<KeyPair> privateKeys = new ArrayList<KeyPair>();
    private static final Logger LOGGER = Logger.getLogger(PrivateKeyProvider.class.getName());

    public List<KeyPair> getKeys() {
        return Collections.unmodifiableList(this.privateKeys);
    }

    public boolean hasKeys() {
        return !this.privateKeys.isEmpty();
    }

    public boolean readFromDefaultLocations() {
        File home = new File(System.getProperty("user.home"));
        boolean read = false;
        for (String path : new String[]{".ssh/id_rsa", ".ssh/id_dsa", ".ssh/identity"}) {
            File key = new File(home, path);
            if (!key.exists()) continue;
            try {
                this.readFrom(key);
                read = true;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failed to load " + key, e);
            }
            catch (GeneralSecurityException e) {
                LOGGER.log(Level.FINE, "Failed to load " + key, e);
            }
        }
        return read;
    }

    public void readFrom(File keyFile) throws IOException, GeneralSecurityException {
        String password = PrivateKeyProvider.isPemEncrypted(keyFile) ? PrivateKeyProvider.askForPasswd(keyFile.getCanonicalPath()) : null;
        this.privateKeys.add(PrivateKeyProvider.loadKey(keyFile, password));
    }

    private static boolean isPemEncrypted(File f) throws IOException {
        return PrivateKeyProvider.readPemFile(f).contains("4,ENCRYPTED");
    }

    private static String askForPasswd(String filePath) {
        Console cons = System.console();
        String passwd = null;
        if (cons != null) {
            char[] p = cons.readPassword("%s", "Enter passphrase for " + filePath + ":");
            passwd = String.valueOf(p);
        }
        return passwd;
    }

    public static KeyPair loadKey(File f, String passwd) throws IOException, GeneralSecurityException {
        return PrivateKeyProvider.loadKey(PrivateKeyProvider.readPemFile(f), passwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readPemFile(File f) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            DataInputStream dis = new DataInputStream(is);
            byte[] bytes = new byte[(int)f.length()];
            dis.readFully(bytes);
            dis.close();
            String string = new String(bytes);
            return string;
        }
    }

    public static KeyPair loadKey(String pemString, String passwd) throws IOException, GeneralSecurityException {
        Object key = PEMDecoder.decode((char[])pemString.toCharArray(), (String)passwd);
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey x = (RSAPrivateKey)key;
            return x.toJCEKeyPair();
        }
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey x = (DSAPrivateKey)key;
            KeyFactory kf = KeyFactory.getInstance("DSA");
            return new KeyPair(kf.generatePublic(new DSAPublicKeySpec(x.getY(), x.getP(), x.getQ(), x.getG())), kf.generatePrivate(new DSAPrivateKeySpec(x.getX(), x.getP(), x.getQ(), x.getG())));
        }
        throw new UnsupportedOperationException("Unrecognizable key format: " + key);
    }
}

