/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey;

import io.jenkins.cli.shaded.org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedFactory;
import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.Signature;
import io.jenkins.cli.shaded.org.apache.sshd.common.signature.SignatureFactoriesManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Objects;

public class KeyPairIdentity
implements PublicKeyIdentity {
    private final KeyPair pair;
    private final Collection<NamedFactory<Signature>> signatureFactories;

    public KeyPairIdentity(SignatureFactoriesManager primary, SignatureFactoriesManager secondary, KeyPair pair) {
        this.signatureFactories = ValidateUtils.checkNotNullAndNotEmpty(SignatureFactoriesManager.resolveSignatureFactories(primary, secondary), "No available signature factories", new Object[0]);
        this.pair = Objects.requireNonNull(pair, "No key pair");
    }

    @Override
    public PublicKey getPublicKey() {
        return this.pair.getPublic();
    }

    @Override
    public byte[] sign(SessionContext session, byte[] data) throws Exception {
        String keyType = KeyUtils.getKeyType(this.getPublicKey());
        Signature verifier = ValidateUtils.checkNotNull(NamedFactory.create(this.signatureFactories, keyType), "No signer could be located for key type=%s", (Object)keyType);
        verifier.initSigner(session, this.pair.getPrivate());
        verifier.update(session, data);
        return verifier.sign(session);
    }

    public String toString() {
        PublicKey pubKey = this.getPublicKey();
        return this.getClass().getSimpleName() + " type=" + KeyUtils.getKeyType(pubKey) + ", factories=" + NamedResource.getNames(this.signatureFactories) + ", fingerprint=" + KeyUtils.getFingerPrint(pubKey);
    }
}

