/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.pem;

import io.jenkins.cli.shaded.org.apache.sshd.common.NamedResource;
import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.ECCurves;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.loader.pem.AbstractPEMResourceKeyPairParser;
import io.jenkins.cli.shaded.org.apache.sshd.common.session.SessionContext;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.NoCloseInputStream;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.der.ASN1Object;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.der.ASN1Type;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.der.DERParser;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ECDSAPEMResourceKeyPairParser
extends AbstractPEMResourceKeyPairParser {
    public static final String BEGIN_MARKER = "BEGIN EC PRIVATE KEY";
    public static final List<String> BEGINNERS = Collections.unmodifiableList(Collections.singletonList("BEGIN EC PRIVATE KEY"));
    public static final String END_MARKER = "END EC PRIVATE KEY";
    public static final List<String> ENDERS = Collections.unmodifiableList(Collections.singletonList("END EC PRIVATE KEY"));
    public static final String ECDSA_OID = "1.2.840.10045.2.1";
    public static final ECDSAPEMResourceKeyPairParser INSTANCE = new ECDSAPEMResourceKeyPairParser();

    public ECDSAPEMResourceKeyPairParser() {
        super("EC", ECDSA_OID, BEGINNERS, ENDERS);
    }

    @Override
    public Collection<KeyPair> extractKeyPairs(SessionContext session, NamedResource resourceKey, String beginMarker, String endMarker, FilePasswordProvider passwordProvider, InputStream stream, Map<String, String> headers) throws IOException, GeneralSecurityException {
        KeyPair kp = ECDSAPEMResourceKeyPairParser.parseECKeyPair(stream, false);
        return Collections.singletonList(kp);
    }

    public static KeyPair parseECKeyPair(InputStream inputStream, boolean okToClose) throws IOException, GeneralSecurityException {
        try (DERParser parser = new DERParser(NoCloseInputStream.resolveInputStream(inputStream, okToClose));){
            KeyPair keyPair = ECDSAPEMResourceKeyPairParser.parseECKeyPair(null, parser);
            return keyPair;
        }
    }

    public static KeyPair parseECKeyPair(ECCurves curve, DERParser parser) throws IOException, GeneralSecurityException {
        ASN1Object sequence = parser.readObject();
        Map.Entry<ECPublicKeySpec, ECPrivateKeySpec> spec = ECDSAPEMResourceKeyPairParser.decodeECPrivateKeySpec(curve, sequence);
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        KeyFactory kf = SecurityUtils.getKeyFactory("EC");
        ECPublicKey pubKey = (ECPublicKey)kf.generatePublic(spec.getKey());
        ECPrivateKey prvKey = (ECPrivateKey)kf.generatePrivate(spec.getValue());
        return new KeyPair(pubKey, prvKey);
    }

    public static Map.Entry<ECPublicKeySpec, ECPrivateKeySpec> decodeECPrivateKeySpec(ECCurves curve, ASN1Object sequence) throws IOException {
        ASN1Type objType;
        ASN1Type aSN1Type = objType = sequence == null ? null : sequence.getObjType();
        if (!ASN1Type.SEQUENCE.equals((Object)objType)) {
            throw new IOException("Invalid DER: not a sequence: " + (Object)((Object)objType));
        }
        try (DERParser parser = sequence.createParser();){
            Map.Entry<ECPrivateKeySpec, ASN1Object> result = ECDSAPEMResourceKeyPairParser.decodeECPrivateKeySpec(curve, parser);
            ECPrivateKeySpec prvSpec = result.getKey();
            ASN1Object publicData = result.getValue();
            ECPoint w = publicData == null ? ECDSAPEMResourceKeyPairParser.decodeECPublicKeyValue(parser) : ECDSAPEMResourceKeyPairParser.decodeECPointData(publicData);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(w, prvSpec.getParams());
            AbstractMap.SimpleImmutableEntry<ECPublicKeySpec, ECPrivateKeySpec> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<ECPublicKeySpec, ECPrivateKeySpec>(pubSpec, prvSpec);
            return simpleImmutableEntry;
        }
    }

    public static Map.Entry<ECPrivateKeySpec, ASN1Object> decodeECPrivateKeySpec(ECCurves curve, DERParser parser) throws IOException {
        ECCurves namedParam;
        ASN1Object versionObject = parser.readObject();
        if (versionObject == null) {
            throw new StreamCorruptedException("No version");
        }
        BigInteger version = versionObject.asInteger();
        if (!BigInteger.ONE.equals(version)) {
            throw new StreamCorruptedException("Bad version value: " + version);
        }
        ASN1Object keyObject = parser.readObject();
        if (keyObject == null) {
            throw new StreamCorruptedException("No private key value");
        }
        ASN1Type objType = keyObject.getObjType();
        if (!ASN1Type.OCTET_STRING.equals((Object)objType)) {
            throw new StreamCorruptedException("Non-matching private key object type: " + (Object)((Object)objType));
        }
        Map.Entry<ECCurves, ASN1Object> result = ECDSAPEMResourceKeyPairParser.parseCurveParameter(parser);
        ECCurves eCCurves = namedParam = result == null ? null : result.getKey();
        if (namedParam == null) {
            if (curve == null) {
                throw new StreamCorruptedException("Cannot determine curve type");
            }
        } else if (curve == null) {
            curve = namedParam;
        } else if (namedParam != curve) {
            throw new StreamCorruptedException("Mismatched provide (" + curve + ") vs. parsed curve (" + namedParam + ")");
        }
        BigInteger s = ECCurves.octetStringToInteger(keyObject.getPureValueBytes());
        ECPrivateKeySpec keySpec = new ECPrivateKeySpec(s, curve.getParameters());
        return new AbstractMap.SimpleImmutableEntry<ECPrivateKeySpec, Object>(keySpec, (result == null ? null : result.getValue()));
    }

    public static Map.Entry<ECCurves, ASN1Object> parseCurveParameter(DERParser parser) throws IOException {
        return ECDSAPEMResourceKeyPairParser.parseCurveParameter(parser.readObject());
    }

    public static Map.Entry<ECCurves, ASN1Object> parseCurveParameter(ASN1Object paramsObject) throws IOException {
        List<Integer> curveOID;
        if (paramsObject == null) {
            return null;
        }
        ASN1Type objType = paramsObject.getObjType();
        if (objType == ASN1Type.NULL) {
            return null;
        }
        try (DERParser paramsParser = paramsObject.createParser();){
            ASN1Object namedCurve = paramsParser.readObject();
            if (namedCurve == null) {
                throw new StreamCorruptedException("Missing named curve parameter");
            }
            objType = namedCurve.getObjType();
            if (objType == ASN1Type.BIT_STRING) {
                AbstractMap.SimpleImmutableEntry<Object, ASN1Object> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Object, ASN1Object>(null, namedCurve);
                return simpleImmutableEntry;
            }
            curveOID = namedCurve.asOID();
        }
        ECCurves curve = ECCurves.fromOIDValue(curveOID);
        if (curve == null) {
            throw new StreamCorruptedException("Unknown curve OID: " + curveOID);
        }
        return new AbstractMap.SimpleImmutableEntry<ECCurves, Object>(curve, null);
    }

    public static final ECPoint decodeECPublicKeyValue(DERParser parser) throws IOException {
        return ECDSAPEMResourceKeyPairParser.decodeECPublicKeyValue(parser.readObject());
    }

    public static final ECPoint decodeECPublicKeyValue(ASN1Object dataObject) throws IOException {
        if (dataObject == null) {
            throw new StreamCorruptedException("No public key data bytes");
        }
        try (DERParser dataParser = dataObject.createParser();){
            ECPoint eCPoint = ECDSAPEMResourceKeyPairParser.decodeECPointData(dataParser.readObject());
            return eCPoint;
        }
    }

    public static final ECPoint decodeECPointData(ASN1Object pointData) throws IOException {
        if (pointData == null) {
            throw new StreamCorruptedException("Missing public key data parameter");
        }
        ASN1Type objType = pointData.getObjType();
        if (!ASN1Type.BIT_STRING.equals((Object)objType)) {
            throw new StreamCorruptedException("Non-matching public key object type: " + (Object)((Object)objType));
        }
        byte[] octets = pointData.getValue();
        return ECCurves.octetStringToEcPoint(octets);
    }
}

