/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client;

import io.jenkins.cli.shaded.org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.BuiltinUserAuthFactories;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.UserAuth;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.UserAuthFactory;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.keyboard.UserInteraction;
import io.jenkins.cli.shaded.org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import io.jenkins.cli.shaded.org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import io.jenkins.cli.shaded.org.apache.sshd.client.session.ClientSession;
import io.jenkins.cli.shaded.org.apache.sshd.common.auth.UserAuthFactoriesManager;
import io.jenkins.cli.shaded.org.apache.sshd.common.keyprovider.KeyIdentityProviderHolder;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import java.security.KeyPair;
import java.util.Collection;
import java.util.List;

public interface ClientAuthenticationManager
extends UserAuthFactoriesManager<ClientSession, UserAuth, UserAuthFactory>,
KeyIdentityProviderHolder {
    public AuthenticationIdentitiesProvider getRegisteredIdentities();

    public PasswordIdentityProvider getPasswordIdentityProvider();

    public void setPasswordIdentityProvider(PasswordIdentityProvider var1);

    public void addPasswordIdentity(String var1);

    public String removePasswordIdentity(String var1);

    public void addPublicKeyIdentity(KeyPair var1);

    public KeyPair removePublicKeyIdentity(KeyPair var1);

    public ServerKeyVerifier getServerKeyVerifier();

    public void setServerKeyVerifier(ServerKeyVerifier var1);

    public UserInteraction getUserInteraction();

    public void setUserInteraction(UserInteraction var1);

    @Override
    default public void setUserAuthFactoriesNames(Collection<String> names) {
        BuiltinUserAuthFactories.ParseResult result = BuiltinUserAuthFactories.parseFactoriesList(names);
        List factories = ValidateUtils.checkNotNullAndNotEmpty(result.getParsedFactories(), "No supported user authentication factories: %s", names);
        List<String> unsupported = result.getUnsupportedFactories();
        ValidateUtils.checkTrue(GenericUtils.isEmpty(unsupported), "Unsupported user authentication factories found: %s", unsupported);
        this.setUserAuthFactories(factories);
    }
}

