/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.closeable;

import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ProxyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.LoggingUtils;
import io.jenkins.cli.shaded.org.slf4j.Logger;
import io.jenkins.cli.shaded.org.slf4j.LoggerFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class AutoCloseableDelegateInvocationHandler
implements InvocationHandler {
    private final Object proxyTarget;
    private final AutoCloseable delegate;
    private final Object[] closers;

    public AutoCloseableDelegateInvocationHandler(Object proxyTarget, AutoCloseable delegate) {
        this.proxyTarget = Objects.requireNonNull(proxyTarget, "No proxy target to wrap");
        this.delegate = Objects.requireNonNull(delegate, "No delegate to auto-close");
        this.closers = new Object[]{proxyTarget, delegate};
    }

    public Object getProxyTarget() {
        return this.proxyTarget;
    }

    public AutoCloseable getAutoCloseableDelegate() {
        return this.delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!AutoCloseableDelegateInvocationHandler.isCloseMethodInvocation(method, args)) {
            Object target = this.getProxyTarget();
            try {
                return method.invoke(target, args);
            }
            catch (Throwable t) {
                Class<?> targetType = target.getClass();
                Logger log = LoggerFactory.getLogger(targetType);
                LoggingUtils.debug(log, "invoke({}#{}) failed ({}) to execute: {}", targetType.getSimpleName(), method.getName(), t.getClass().getSimpleName(), t.getMessage(), t);
                throw ProxyUtils.unwrapInvocationThrowable(t);
            }
        }
        Throwable err = null;
        for (Object c : this.closers) {
            if (!(c instanceof AutoCloseable)) continue;
            try {
                method.invoke(c, args);
            }
            catch (Throwable t) {
                Class<?> closerType = c.getClass();
                Logger log = LoggerFactory.getLogger(closerType);
                LoggingUtils.debug(log, "invoke({}#{}) failed ({}) to execute: {}", closerType.getSimpleName(), method.getName(), t.getClass().getSimpleName(), t.getMessage(), t);
                err = GenericUtils.accumulateException(err, t);
            }
        }
        if (err != null) {
            throw ProxyUtils.unwrapInvocationThrowable(err);
        }
        return null;
    }

    public static <T extends AutoCloseable> T wrapDelegateCloseable(Object proxyTarget, Class<T> type, AutoCloseable delegate) {
        return (T)((AutoCloseable)ProxyUtils.newProxyInstance(type, new AutoCloseableDelegateInvocationHandler(proxyTarget, delegate)));
    }

    public static boolean isCloseMethodInvocation(Method m, Object[] args) {
        return AutoCloseableDelegateInvocationHandler.isCloseMethod(m) && GenericUtils.isEmpty(args);
    }

    public static boolean isCloseMethod(Method m) {
        int mods = m == null ? 0 : m.getModifiers();
        return m != null && "close".equals(m.getName()) && Modifier.isPublic(mods) && !Modifier.isStatic(mods) && Void.TYPE == m.getReturnType() && GenericUtils.isEmpty(m.getParameterTypes());
    }
}

